/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client;

import java.util.Collection;
import java.util.Comparator;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.glassfish.jersey.client.spi.ClientComponentProvider;
import org.glassfish.jersey.internal.BootstrapBag;
import org.glassfish.jersey.internal.BootstrapConfigurator;
import org.glassfish.jersey.internal.ServiceConfigurationError;
import org.glassfish.jersey.internal.ServiceFinder;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.internal.util.collection.LazyValue;
import org.glassfish.jersey.internal.util.collection.Values;
import org.glassfish.jersey.model.internal.RankedComparator;
import org.glassfish.jersey.model.internal.RankedProvider;
import org.glassfish.jersey.spi.ComponentProvider;

public class ClientComponentProviderConfigurator
implements BootstrapConfigurator {
    private static final Comparator<RankedProvider<ClientComponentProvider>> RANKED_COMPARATOR = new RankedComparator(RankedComparator.Order.DESCENDING);

    public void init(InjectionManager injectionManager, BootstrapBag bootstrapBag) {
        LazyValue componentProviders = Values.lazy(() -> ClientComponentProviderConfigurator.getRankedComponentProviders().stream().map(RankedProvider::getProvider).peek(provider -> provider.initialize(injectionManager)).collect(Collectors.toList()));
        bootstrapBag.setComponentProviders(componentProviders);
    }

    public void postInit(InjectionManager injectionManager, BootstrapBag bootstrapBag) {
        ((Collection)bootstrapBag.getComponentProviders().get()).forEach(ComponentProvider::done);
    }

    private static Collection<RankedProvider<ClientComponentProvider>> getRankedComponentProviders() throws ServiceConfigurationError {
        return StreamSupport.stream(ServiceFinder.find(ClientComponentProvider.class).spliterator(), false).map(RankedProvider::new).sorted(RANKED_COMPARATOR).collect(Collectors.toList());
    }
}

