/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.openid.domain;

import com.nimbusds.jwt.EncryptedJWT;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import fish.payara.security.openid.api.IdentityToken;
import fish.payara.security.openid.domain.OpenIdConfiguration;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Objects;

public class IdentityTokenImpl
implements IdentityToken {
    private final String token;
    private final JWT tokenJWT;
    private Map<String, Object> claims;
    private OpenIdConfiguration configuration;

    public IdentityTokenImpl(OpenIdConfiguration configuration, String token) {
        this.configuration = configuration;
        this.token = token;
        try {
            this.tokenJWT = JWTParser.parse((String)token);
            this.claims = this.tokenJWT.getJWTClaimsSet().getClaims();
        }
        catch (ParseException ex) {
            throw new IllegalStateException("Error in parsing the Token", ex);
        }
    }

    public JWT getTokenJWT() {
        return this.tokenJWT;
    }

    public String getToken() {
        return this.token;
    }

    public Map<String, Object> getClaims() {
        if (this.claims == null) {
            return Collections.emptyMap();
        }
        return this.claims;
    }

    public void setClaims(Map<String, Object> claims) {
        this.claims = claims;
    }

    public Object getClaim(String key) {
        return this.getClaims().get(key);
    }

    public boolean isEncrypted() {
        return this.tokenJWT != null && this.tokenJWT instanceof EncryptedJWT;
    }

    public boolean isSigned() {
        return this.tokenJWT != null && this.tokenJWT instanceof EncryptedJWT;
    }

    public boolean isExpired() {
        boolean expired = true;
        Date exp = (Date)this.getClaim("exp");
        if (!Objects.nonNull(exp)) {
            throw new IllegalStateException("Missing expiration time (exp) claim in identity token");
        }
        expired = System.currentTimeMillis() + (long)this.configuration.getTokenMinValidity() > exp.getTime();
        return expired;
    }

    public String toString() {
        return this.token;
    }
}

