/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client.packageappclient;

import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipException;

public class PackageAppClient {
    private static final String OUTPUT_PREFIX = "appclient/";
    private static final String GLASSFISH_LIB = "glassfish/lib";
    private static final String GLASSFISH_BIN = "glassfish/bin";
    private static final String GLASSFISH_CONFIG = "glassfish/config";
    private static final String MQ_LIB = "mq/lib";
    private static final String DOMAIN_1_CONFIG = "glassfish/domains/domain1/config";
    private static final String INDENT = "  ";
    private static final String ACC_CONFIG_FILE_DEFAULT = "/glassfish-acc.xml";
    private static final String ACC_CONFIG_FILE_DEFAULT_OLD = "/sun-acc.xml";
    private static final String[] DIRS_TO_COPY = new String[]{"glassfish/lib/dtds", "glassfish/lib/schemas", "glassfish/lib/appclient"};
    private static final String DEFAULT_ACC_XML = "glassfish/domains/domain1/config/glassfish-acc.xml";
    private static final String OLD_ACC_XML = "glassfish/domains/domain1/config/sun-acc.xml";
    private static final String[] DEFAULT_ACC_CONFIG_FILES = new String[]{"glassfish/domains/domain1/config/glassfish-acc.xml", "glassfish/domains/domain1/config/sun-acc.xml"};
    private static final String IMQJMSRA_APP = "glassfish/lib/install/applications/jmsra/imqjmsra.jar";
    private static final String IMQ_JAR = "mq/lib/imq.jar";
    private static final String IMQADMIN_JAR = "mq/lib/imqadmin.jar";
    private static final String IMQUTIL_JAR = "mq/lib/imqutil.jar";
    private static final String FSCONTEXT_JAR = "mq/lib/fscontext.jar";
    private static final String WIN_SCRIPT = "glassfish/bin/appclient.bat";
    private static final String WIN_JS = "glassfish/bin/appclient.js";
    private static final String NONWIN_SCRIPT = "glassfish/bin/appclient";
    private static final String ASENV_CONF = "glassfish/config/asenv.conf";
    private static final String ASENV_BAT = "glassfish/config/asenv.bat";
    private static final char UNIX_SEPARATOR = '/';
    private static final char WINDOWS_SEPARATOR = '\\';
    private static final String[] SINGLE_FILES_TO_COPY = new String[]{"glassfish/lib/install/applications/jmsra/imqjmsra.jar", "mq/lib/imq.jar", "mq/lib/imqadmin.jar", "mq/lib/imqutil.jar", "mq/lib/fscontext.jar", "glassfish/bin/appclient.bat", "glassfish/bin/appclient.js", "glassfish/bin/appclient", "glassfish/config/asenv.conf", "glassfish/config/asenv.bat"};
    private static final String DEFAULT_OUTPUT_PATH = "glassfish/lib/appclient.jar";
    private static final LocalStringsImpl strings = new LocalStringsImpl(PackageAppClient.class);
    private boolean isVerbose;

    public static void main(String[] args) {
        try {
            new PackageAppClient().run(args);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void run(String[] args) throws URISyntaxException, IOException {
        this.isVerbose = this.isVerboseOutputLevel(args);
        File thisJarFile = this.findCurrentJarFile();
        File installDir = this.findInstallDir(thisJarFile);
        File modulesDir = new File(installDir.toURI().resolve("glassfish/modules/"));
        File tempFile = File.createTempFile("appc", ".tmp", installDir);
        File outputFile = this.chooseOutputFile(installDir, args);
        File[] configFiles = this.chooseConfigFiles(installDir, args);
        String[] classPathElements = this.getJarClassPath(thisJarFile).split(" ");
        JarOutputStream os = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(tempFile)));
        this.addFile(os, installDir.toURI(), thisJarFile.toURI(), tempFile, "");
        for (String classPathElement : classPathElements) {
            File classPathJAR = new File(modulesDir, classPathElement);
            this.addFile(os, installDir.toURI(), modulesDir.toURI().resolve(classPathJAR.toURI()), tempFile, "");
        }
        for (String dirToCopy : DIRS_TO_COPY) {
            this.addDir(os, installDir.toURI(), installDir.toURI().resolve(dirToCopy), tempFile, "");
        }
        for (String singleFileToCopy : SINGLE_FILES_TO_COPY) {
            this.addFile(os, installDir.toURI(), installDir.toURI().resolve(singleFileToCopy), tempFile, "");
        }
        boolean customConfigFileProvided = this.argValue("-xml", args) != null;
        for (File configFile : configFiles) {
            if (!customConfigFileProvided) {
                this.addFile(os, installDir.toURI(), configFile.toURI(), tempFile, "");
                continue;
            }
            this.addFile(os, configFile.toURI(), tempFile, "", DOMAIN_1_CONFIG + File.separator + this.getFileName(configFile.toURI().toString()));
        }
        os.close();
        this.placeFile(tempFile, outputFile);
    }

    private void placeFile(File tempFile, File outputFile) {
        if (outputFile.exists()) {
            if (!outputFile.delete()) {
                throw new RuntimeException(strings.get("errDel", new Object[]{outputFile.getAbsolutePath()}));
            }
            System.out.println(strings.get("replacingFile", new Object[]{outputFile.getAbsolutePath()}));
        } else {
            System.out.println(strings.get("creatingFile", new Object[]{outputFile.getAbsolutePath()}));
        }
        if (this.isVerbose) {
            System.out.println(strings.get("moving", new Object[]{tempFile.getAbsolutePath(), outputFile.getAbsolutePath()}));
        }
        if (!tempFile.renameTo(outputFile)) {
            throw new RuntimeException(strings.get("errRenaming", new Object[]{tempFile.getAbsolutePath(), outputFile.getAbsolutePath()}));
        }
    }

    private void addFile(JarOutputStream os, URI installDirURI, URI absoluteURIToAdd, File outputFile, String indent) throws IOException {
        this.addFile(os, absoluteURIToAdd, outputFile, indent, installDirURI.relativize(absoluteURIToAdd).toString());
    }

    private void addFile(JarOutputStream os, URI absoluteURIToAdd, File outputFile, String indent, String relativizedURL) throws IOException {
        try {
            File fileToCopy;
            if (this.isVerbose) {
                System.err.println(indent + strings.get("addingFile", new Object[]{absoluteURIToAdd}));
            }
            if ((fileToCopy = new File(absoluteURIToAdd)).equals(outputFile)) {
                return;
            }
            JarEntry entry = new JarEntry(OUTPUT_PREFIX + relativizedURL);
            try {
                if (!new File(absoluteURIToAdd).exists()) {
                    if (this.isVerbose) {
                        System.err.println(indent + strings.get("noFile", new Object[]{new File(absoluteURIToAdd).getAbsolutePath()}));
                    }
                    return;
                }
                os.putNextEntry(entry);
                if (new File(absoluteURIToAdd).isFile()) {
                    this.copyFileToStream(os, absoluteURIToAdd);
                }
                os.closeEntry();
            }
            catch (ZipException e) {
                if (this.isVerbose) {
                    System.err.println(indent + strings.get("zipExc", new Object[]{e.getLocalizedMessage()}));
                }
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
        catch (Exception ex) {
            throw new IOException(absoluteURIToAdd.toASCIIString(), ex);
        }
    }

    private String getFileName(String filename) {
        if (filename == null) {
            return null;
        }
        int index = this.indexOfLastSeparator(filename);
        return filename.substring(index + 1);
    }

    private int indexOfLastSeparator(String filename) {
        if (filename == null) {
            return -1;
        }
        int lastUnixPos = filename.lastIndexOf(47);
        int lastWindowsPos = filename.lastIndexOf(92);
        return Math.max(lastUnixPos, lastWindowsPos);
    }

    private void addDir(JarOutputStream os, URI installDirURI, URI absoluteDirURIToAdd, File outputFile, String indent) throws IOException {
        this.addDir(os, installDirURI, absoluteDirURIToAdd, null, outputFile, indent);
    }

    private void addDir(JarOutputStream os, URI installDirURI, URI absoluteDirURIToAdd, FileFilter fileFilter, File outputFile, String indent) throws IOException {
        File dirFile = new File(absoluteDirURIToAdd);
        File[] matchingFiles = dirFile.listFiles(fileFilter);
        if (matchingFiles == null) {
            return;
        }
        if (this.isVerbose) {
            System.err.println(indent + strings.get("addingDir", new Object[]{dirFile.getAbsolutePath()}));
        }
        for (File fileToAdd : matchingFiles) {
            if (fileToAdd.isFile()) {
                this.addFile(os, installDirURI, fileToAdd.toURI(), outputFile, indent + INDENT);
                continue;
            }
            if (!fileToAdd.isDirectory()) continue;
            this.addDir(os, installDirURI, fileToAdd.toURI(), outputFile, indent + INDENT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFileToStream(OutputStream os, URI uriToCopy) throws IOException {
        File fileToCopy = new File(uriToCopy);
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(fileToCopy));){
            int bytesRead;
            byte[] buffer = new byte[4096];
            while ((bytesRead = ((InputStream)is).read(buffer)) != -1) {
                os.write(buffer, 0, bytesRead);
            }
        }
    }

    private File chooseOutputFile(File installDir, String[] args) {
        return this.chooseFile("-output", DEFAULT_OUTPUT_PATH, installDir, args);
    }

    private File chooseFile(String option, String defaultRelativeURI, File installDir, String[] args) {
        File result;
        String optionValue = this.argValue(option, args);
        if (optionValue != null) {
            result = new File(optionValue);
        } else {
            URI outputFileURI = installDir.toURI().resolve(defaultRelativeURI);
            result = new File(outputFileURI);
        }
        return result;
    }

    private File[] chooseConfigFiles(File installDir, String[] args) {
        File[] files;
        String xmlArg = this.argValue("-xml", args);
        if (xmlArg == null) {
            files = new File[DEFAULT_ACC_CONFIG_FILES.length];
            int slot = 0;
            for (String s : DEFAULT_ACC_CONFIG_FILES) {
                files[slot++] = new File(installDir.toURI().resolve(s));
            }
        } else {
            File userSpecifiedFile = new File(xmlArg);
            files = new File[]{userSpecifiedFile};
            if (!userSpecifiedFile.exists()) {
                System.err.println(strings.get("xmlNotFound", new Object[]{userSpecifiedFile.getAbsolutePath()}));
            }
        }
        return files;
    }

    private File findInstallDir(File currentJarFile) throws URISyntaxException {
        return currentJarFile.getParentFile().getParentFile().getParentFile();
    }

    private boolean isVerboseOutputLevel(String[] args) {
        for (String arg : args) {
            if (!arg.equals("-verbose")) continue;
            return true;
        }
        return false;
    }

    private String argValue(String option, String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals(option)) continue;
            if (i + 1 < args.length) {
                return args[i + 1];
            }
            throw new IllegalArgumentException(option);
        }
        return null;
    }

    private File findCurrentJarFile() throws URISyntaxException {
        URI thisJarURI = this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI();
        URI thisJarFileBasedURI = thisJarURI.getScheme().startsWith("jar") ? URI.create("file:" + thisJarURI.getRawSchemeSpecificPart()) : thisJarURI;
        File result = new File(thisJarFileBasedURI);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getJarClassPath(File currentJarFile) throws IOException {
        try (JarFile jf = null;){
            String classPath;
            jf = new JarFile(currentJarFile);
            Manifest mf = jf.getManifest();
            Attributes mainAttrs = mf.getMainAttributes();
            String string = classPath = mainAttrs.getValue(Attributes.Name.CLASS_PATH);
            return string;
        }
    }
}

