/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.console.util;

import com.sun.messaging.jmq.admin.apps.console.util.IntegerField;
import com.sun.messaging.jmq.admin.resources.AdminConsoleResources;
import com.sun.messaging.jmq.admin.util.Globals;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class TimeField
extends JPanel {
    public static final int MILLISECONDS = 0;
    public static final int SECONDS = 1;
    public static final int MINUTES = 2;
    public static final int HOURS = 3;
    public static final int DAYS = 4;
    private int msecPos = 0;
    private int secPos = 1;
    private int minPos = 2;
    private int hrPos = 3;
    private int dayPos = 4;
    private boolean showMillis = false;
    private static AdminConsoleResources acr = Globals.getAdminConsoleResources();
    private IntegerField intF;
    private JComboBox unitCB;

    public TimeField(long max, String text) {
        this(max, text, 0);
    }

    public TimeField(long max, int columns) {
        this(max, null, columns);
    }

    public TimeField(long max, String text, int columns) {
        this(max, text, columns, false);
    }

    public TimeField(long max, String text, int columns, boolean showMillis) {
        this.showMillis = showMillis;
        this.initGui(max, text, columns);
        this.setUnit(1);
    }

    public void addActionListener(ActionListener l) {
        this.intF.addActionListener(l);
    }

    public void setText(String s) {
        this.intF.setText(s);
    }

    public String getText() {
        return this.intF.getText();
    }

    @Override
    public void setEnabled(boolean b) {
        this.intF.setEnabled(b);
        this.unitCB.setEnabled(b);
    }

    public void setUnit(int unit) {
        int index = this.secPos;
        switch (unit) {
            case 0: {
                index = this.msecPos;
                break;
            }
            case 1: {
                index = this.secPos;
                break;
            }
            case 2: {
                index = this.minPos;
                break;
            }
            case 3: {
                index = this.hrPos;
                break;
            }
            case 4: {
                index = this.dayPos;
            }
        }
        if (index < 0 || index > this.dayPos) {
            return;
        }
        this.unitCB.setSelectedIndex(index);
    }

    public long getValue() {
        long tmpLong;
        String s = this.intF.getText();
        try {
            tmpLong = Long.parseLong(s);
        }
        catch (Exception e) {
            return -1L;
        }
        int selIndex = this.unitCB.getSelectedIndex();
        if (this.showMillis) {
            if (selIndex == this.msecPos) {
                return tmpLong;
            }
            if (selIndex == this.secPos) {
                return tmpLong * 1000L;
            }
            if (selIndex == this.minPos) {
                return tmpLong * 1000L * 60L;
            }
            if (selIndex == this.hrPos) {
                return tmpLong * 1000L * 60L * 60L;
            }
            if (selIndex == this.dayPos) {
                return tmpLong * 1000L * 60L * 60L * 24L;
            }
        } else {
            if (selIndex == this.secPos) {
                return tmpLong * 1000L;
            }
            if (selIndex == this.minPos) {
                return tmpLong * 1000L * 60L;
            }
            if (selIndex == this.hrPos) {
                return tmpLong * 1000L * 60L * 60L;
            }
            if (selIndex == this.dayPos) {
                return tmpLong * 1000L * 60L * 60L * 24L;
            }
        }
        return -1L;
    }

    private void initGui(long max, String text, int collumns) {
        String[] units;
        this.intF = new IntegerField(0L, max, text, collumns);
        if (this.showMillis) {
            this.msecPos = 0;
            this.secPos = 1;
            this.minPos = 2;
            this.hrPos = 3;
            this.dayPos = 4;
            units = new String[5];
            units[this.msecPos] = acr.getString("A1226");
        } else {
            this.secPos = 0;
            this.minPos = 1;
            this.hrPos = 2;
            this.dayPos = 3;
            units = new String[4];
        }
        units[this.secPos] = acr.getString("A1227");
        units[this.minPos] = acr.getString("A1228");
        units[this.hrPos] = acr.getString("A1229");
        units[this.dayPos] = acr.getString("A1230");
        this.unitCB = new JComboBox<String>(units);
        this.setLayout(new BorderLayout());
        this.add((Component)this.intF, "Center");
        this.add((Component)this.unitCB, "East");
    }
}

