/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.common;

import com.sun.enterprise.security.permissionsxml.CommponentType;
import com.sun.enterprise.security.permissionsxml.PermissionsXMLLoader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.cert.Certificate;
import javax.xml.stream.XMLStreamException;
import sun.security.provider.PolicyFile;

public class PermissionsUtil {
    protected static final String PERMISSIONS_XML = "META-INF/permissions.xml";
    protected static final String CLIENT_EE_PERMS_FILE = "javaee.client.policy";
    protected static final String CLIENT_EE_PERMS_PKG = "META-INF/javaee.client.policy";
    protected static final String CLIENT_RESTRICT_PERMS_FILE = "restrict.client.policy";
    protected static final String CLIENT_RESTRICT_PERMS_PKG = "META-INF/restrict.client.policy";

    public static PermissionCollection getClientDeclaredPermissions(ClassLoader cl) throws IOException {
        URL permissionsURL = cl.getResource(PERMISSIONS_XML);
        if (permissionsURL == null) {
            return null;
        }
        InputStream declaredPermInput = permissionsURL.openStream();
        try {
            return new PermissionsXMLLoader(null, declaredPermInput, CommponentType.car).getAppDeclaredPermissions();
        }
        catch (FileNotFoundException | XMLStreamException e) {
            throw new IOException(e);
        }
    }

    public static PermissionCollection getClientEEPolicy(ClassLoader cl) throws IOException {
        return PermissionsUtil.getClientPolicy(cl, CLIENT_EE_PERMS_PKG, CLIENT_EE_PERMS_FILE);
    }

    public static PermissionCollection getClientRestrictPolicy(ClassLoader cl) throws IOException {
        return PermissionsUtil.getClientPolicy(cl, CLIENT_RESTRICT_PERMS_PKG, CLIENT_RESTRICT_PERMS_FILE);
    }

    private static PermissionCollection getClientPolicy(ClassLoader cl, String pkgedFile, String policyFileName) throws IOException {
        URL eeClientUrl = cl.getResource(pkgedFile);
        if (eeClientUrl != null) {
            return PermissionsUtil.getEEPolicyPermissions(eeClientUrl);
        }
        String clientPolicyClocation = PermissionsUtil.getClientInstalledPath();
        if (clientPolicyClocation != null) {
            String clietEEFile = clientPolicyClocation + policyFileName;
            return PermissionsUtil.getPolicyPermissions(clietEEFile);
        }
        return null;
    }

    private static PermissionCollection getEEPolicyPermissions(URL fileUrl) throws IOException {
        PolicyFile policyFile = new PolicyFile(fileUrl);
        return policyFile.getPermissions(new CodeSource(new URL("file:/module/Car"), (Certificate[])null));
    }

    private static PermissionCollection getPolicyPermissions(String policyFilename) throws IOException {
        if (!new File(policyFilename).exists()) {
            return null;
        }
        return PermissionsUtil.getEEPolicyPermissions(new URL("file:" + policyFilename));
    }

    private static String getClientInstalledPath() {
        String policyPath = System.getProperty("java.security.policy");
        if (policyPath == null) {
            return null;
        }
        return new File(policyPath).getParent() + File.separator;
    }
}

