/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.stringsubs.impl;

import com.sun.enterprise.admin.servermgmt.SLogger;
import com.sun.enterprise.admin.servermgmt.stringsubs.Substitutable;
import com.sun.enterprise.admin.servermgmt.stringsubs.impl.FileLister;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Reader;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class FileSubstitutionHandler
implements Substitutable {
    protected static final Logger LOGGER = SLogger.getLogger();
    protected static final LocalStringsImpl STRINGS = new LocalStringsImpl(FileLister.class);
    protected Reader reader;
    protected Writer writer;
    protected File inputFile;

    public FileSubstitutionHandler(File file) throws FileNotFoundException {
        if (!file.exists()) {
            throw new FileNotFoundException(STRINGS.get("invalidFileLocation", new Object[]{file.getAbsolutePath()}));
        }
        this.inputFile = file;
    }

    @Override
    public String getName() {
        return this.inputFile.getAbsolutePath();
    }

    @Override
    public void finish() {
        block7: {
            block6: {
                if (this.reader != null) {
                    try {
                        this.reader.close();
                    }
                    catch (Exception e) {
                        if (!LOGGER.isLoggable(Level.FINER)) break block6;
                        LOGGER.log(Level.FINER, STRINGS.get("errorInClosingStream", new Object[]{this.inputFile.getAbsolutePath()}), e);
                    }
                }
            }
            if (this.writer != null) {
                try {
                    this.writer.close();
                }
                catch (Exception e) {
                    if (!LOGGER.isLoggable(Level.FINER)) break block7;
                    LOGGER.log(Level.FINER, STRINGS.get("errorInClosingStream"), e);
                }
            }
        }
    }
}

