/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.optional;

import com.sun.enterprise.admin.cli.CLIProcessExecutor;
import com.sun.enterprise.admin.cli.CLIUtil;
import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.admin.cli.optional.DatabaseCommand;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.universal.io.SmartFile;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="stop-database")
@PerLookup
public final class StopDatabaseCommand
extends DatabaseCommand {
    @Param(name="dbuser", optional=true)
    private String dbUser;
    private File dbPasswordFile;
    private String dbPassword;
    private static final LocalStringsImpl strings = new LocalStringsImpl(StopDatabaseCommand.class);

    public String[] stopDatabaseCmd() throws Exception {
        this.passwords = new HashMap();
        String passwordfile = this.getOption("passwordfile");
        if (passwordfile != null) {
            this.dbPasswordFile = new File(passwordfile);
            this.dbPasswordFile = SmartFile.sanitize(this.dbPasswordFile);
        }
        if (this.dbPasswordFile != null) {
            this.passwords = CLIUtil.readPasswordFileOptions((String)this.dbPasswordFile.getPath(), (boolean)true);
            this.dbPassword = (String)this.passwords.get(Environment.getPrefix() + "DBPASSWORD");
        }
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(this.sJavaHome + File.separator + "bin" + File.separator + "java");
        cmd.add("-Djava.library.path=" + this.sInstallRoot + File.separator + "lib");
        cmd.addAll(this.dbManager.getSystemProperty());
        cmd.add("-cp");
        cmd.add(this.sClasspath + File.pathSeparator + this.sDatabaseClasspath);
        cmd.add(this.dbManager.getDBControl().getName());
        cmd.add("shutdown");
        cmd.add(this.dbHost);
        cmd.add(this.dbPort);
        cmd.add("false");
        if (this.dbUser != null && this.dbPassword != null) {
            cmd.add(this.dbUser);
            cmd.add(this.dbPassword);
        }
        return cmd.toArray(new String[cmd.size()]);
    }

    protected int executeCommand() throws CommandException, CommandValidationException {
        try {
            this.prepareProcessExecutor();
            CLIProcessExecutor cpe = new CLIProcessExecutor();
            cpe.execute("pingDatabaseCmd", this.pingDatabaseCmd(false), true);
            if (cpe.exitValue() > 0) {
                throw new CommandException(strings.get("StopDatabaseStatus", this.dbHost, this.dbPort));
            }
            if (cpe.exitValue() < 0) {
                throw new CommandException(strings.get("UnableToStopDatabase", this.dbManager.getLogFileName()));
            }
            cpe.execute("stopDatabaseCmd", this.stopDatabaseCmd(), true);
            if (cpe.exitValue() > 0) {
                throw new CommandException(strings.get("UnableToStopDatabase", this.dbManager.getLogFileName()));
            }
        }
        catch (Exception e) {
            throw new CommandException(strings.get("UnableToStopDatabase", this.dbManager.getLogFileName()), (Throwable)e);
        }
        return 0;
    }
}

