/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers.interceptors;

import com.sun.ejb.containers.interceptors.AroundInvokeInterceptor;
import com.sun.ejb.containers.interceptors.InterceptorManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

class BeanAroundInvokeInterceptor
extends AroundInvokeInterceptor {
    BeanAroundInvokeInterceptor(Method method) {
        super(-1, method);
    }

    @Override
    Object intercept(InterceptorManager.AroundInvokeContext invCtx) throws Throwable {
        try {
            if (System.getSecurityManager() != null) {
                PrivilegedExceptionAction<Object> action = () -> this.method.invoke(invCtx.getTarget(), invCtx);
                return AccessController.doPrivileged(action);
            }
            return this.method.invoke(invCtx.getTarget(), invCtx);
        }
        catch (InvocationTargetException invEx) {
            throw invEx.getCause();
        }
        catch (PrivilegedActionException paEx) {
            Throwable th = paEx.getCause();
            if (th.getCause() != null) {
                throw th.getCause();
            }
            throw th;
        }
    }
}

