/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.jaspic.config;

import com.sun.enterprise.security.SecurityServicesUtil;
import com.sun.enterprise.security.jaspic.WebServicesDelegate;
import com.sun.enterprise.security.jaspic.config.GFServerConfigProvider;
import com.sun.jaspic.config.factory.BaseAuthConfigFactory;
import com.sun.jaspic.config.factory.EntryInfo;
import com.sun.jaspic.config.factory.RegStoreFileParser;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;

public class GFAuthConfigFactory
extends BaseAuthConfigFactory {
    private static RegStoreFileParser regStore;

    public GFAuthConfigFactory() {
        if (((Boolean)this.doReadLocked(() -> regStore != null)).booleanValue()) {
            return;
        }
        String userDir = System.getProperty("user.dir");
        this.doWriteLocked(() -> {
            if (regStore == null) {
                GFAuthConfigFactory.initializeRegStore(userDir);
                this._loadFactory();
            }
        });
    }

    private static void initializeRegStore(String userDir) {
        regStore = new RegStoreFileParser(userDir, "auth.conf", GFAuthConfigFactory.getDefaultProviders());
    }

    protected RegStoreFileParser getRegStore() {
        return (RegStoreFileParser)this.doReadLocked(() -> regStore);
    }

    private static List<EntryInfo> getDefaultProviders() {
        WebServicesDelegate delegate = null;
        SecurityServicesUtil securityServicesUtil = SecurityServicesUtil.getInstance();
        if (securityServicesUtil != null) {
            delegate = securityServicesUtil.getHabitat().getService(WebServicesDelegate.class, new Annotation[0]);
        }
        if (delegate != null) {
            return Arrays.asList(new EntryInfo(delegate.getDefaultWebServicesProvider()), new EntryInfo(GFServerConfigProvider.class.getName()));
        }
        return Arrays.asList(new EntryInfo(GFServerConfigProvider.class.getName()));
    }
}

