/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.ee;

import com.sun.enterprise.security.ContainerSecurityLifecycle;
import com.sun.enterprise.security.ee.J2EESecurityManager;
import com.sun.enterprise.security.jaspic.config.GFAuthConfigFactory;
import com.sun.logging.LogDomains;
import java.security.Security;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Singleton;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.Rank;
import org.glassfish.internal.api.InitRunLevel;
import org.jvnet.hk2.annotations.Service;

@InitRunLevel
@Rank(value=50)
@Service
@Singleton
public class JavaEESecurityLifecycle
implements ContainerSecurityLifecycle,
PostConstruct {
    private static final Logger LOG = LogDomains.getLogger(JavaEESecurityLifecycle.class, (String)"javax.enterprise.system.core.security");

    @Override
    public void postConstruct() {
        this.onInitialization();
    }

    @Override
    public void onInitialization() {
        LOG.finest(() -> "Initializing " + this.getClass());
        SecurityManager systemSecurityManager = System.getSecurityManager();
        if (systemSecurityManager != null && !J2EESecurityManager.class.equals(systemSecurityManager.getClass())) {
            J2EESecurityManager eeSecurityManager = new J2EESecurityManager();
            try {
                System.setSecurityManager(eeSecurityManager);
                LOG.config(() -> "System security manager has been set to " + eeSecurityManager);
            }
            catch (SecurityException ex) {
                LOG.log(Level.WARNING, "security.secmgr.could.not.override", ex);
            }
        }
        this.initializeJASPIC();
    }

    private void initializeJASPIC() {
        String defaultFactory = Security.getProperty("authconfigprovider.factory");
        if (defaultFactory == null) {
            String defaultAuthConfigProvideFactoryClassName = GFAuthConfigFactory.class.getName();
            Security.setProperty("authconfigprovider.factory", defaultAuthConfigProvideFactoryClassName);
            LOG.config(() -> String.format("System JVM option '%s' has been set to '%s'", "authconfigprovider.factory", defaultAuthConfigProvideFactoryClassName));
        }
    }
}

