/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.microprofile.config.source.extension;

import com.sun.enterprise.config.serverbeans.Config;
import fish.payara.nucleus.microprofile.config.source.extension.ConfigSourceExtensions;
import fish.payara.nucleus.microprofile.config.source.extension.ExtensionConfigSource;
import fish.payara.nucleus.microprofile.config.source.extension.ExtensionConfigSourceHandler;
import fish.payara.nucleus.microprofile.config.spi.ConfigSourceConfiguration;
import fish.payara.nucleus.microprofile.config.spi.MicroprofileConfigConfiguration;
import java.beans.PropertyChangeEvent;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.Changed;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.NotProcessed;
import org.jvnet.hk2.config.Transactions;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

@Service(name="config-source-extension-handler")
public class ExtensionConfigSourceService
implements EventListener,
ConfigListener {
    private static final Logger logger = Logger.getLogger(ExtensionConfigSourceService.class.getName());
    @Inject
    @Named(value="default-instance-name")
    @Optional
    private MicroprofileConfigConfiguration configuration;
    @Inject
    private ServiceLocator locator;
    @Inject
    private Events events;
    @Inject
    private Transactions transactions;
    private final Set<ExtensionConfigSourceHandler> handlers = new HashSet<ExtensionConfigSourceHandler>();
    private boolean isInstance;

    @PostConstruct
    void initialize() {
        if (this.configuration == null) {
            this.configuration = this.locator.getService(MicroprofileConfigConfiguration.class, new Annotation[0]);
        }
        if (this.events != null) {
            this.events.register((EventListener)this);
        }
        ServerEnvironment env = this.locator.getService(ServerEnvironment.class, new Annotation[0]);
        this.isInstance = env.isInstance();
        List<ServiceHandle<ExtensionConfigSource>> configSourceHandles = this.locator.getAllServiceHandles(ExtensionConfigSource.class, new Annotation[0]);
        for (ServiceHandle<ExtensionConfigSource> configSourceHandle : configSourceHandles) {
            Class<?> extensionClass = configSourceHandle.getActiveDescriptor().getImplementationClass();
            Class<ConfigSourceConfiguration> configClass = ConfigSourceExtensions.getConfigurationClass(extensionClass);
            if (configClass != null) {
                this.handlers.add(new ExtensionConfigSourceHandler(configSourceHandle, configClass, (ConfigSourceConfiguration)this.configuration.getConfigSourceConfigurationByType(configClass)));
                continue;
            }
            this.handlers.add(new ExtensionConfigSourceHandler(configSourceHandle));
        }
    }

    @PreDestroy
    void destroy() {
        this.handlers.clear();
        if (this.events != null) {
            this.events.unregister((EventListener)this);
        }
    }

    public void event(EventListener.Event<?> event) {
        if (event.is(EventTypes.SERVER_READY)) {
            this.bootstrapConfigSources();
        }
        if (event.is(EventTypes.SERVER_SHUTDOWN)) {
            this.shutdownConfigSources();
        }
        this.transactions.addListenerForType(MicroprofileConfigConfiguration.class, (ConfigListener)this);
    }

    public Set<ExtensionConfigSource> getExtensionSources() {
        HashSet<ExtensionConfigSource> sources = new HashSet<ExtensionConfigSource>();
        for (ExtensionConfigSourceHandler handler : this.handlers) {
            sources.add(handler.getProxyConfigSource());
        }
        return sources;
    }

    private void bootstrapConfigSources() {
        this.handlers.forEach(ExtensionConfigSourceHandler::bootstrap);
    }

    private void shutdownConfigSources() {
        this.handlers.forEach(ExtensionConfigSourceHandler::destroy);
    }

    public UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        boolean isCurrentInstanceMatchTarget = false;
        if (this.isInstance) {
            isCurrentInstanceMatchTarget = true;
        } else {
            for (PropertyChangeEvent pe : events) {
                ConfigBeanProxy proxy;
                for (proxy = (ConfigBeanProxy)pe.getSource(); proxy != null && !(proxy instanceof Config); proxy = proxy.getParent()) {
                }
                if (proxy == null || !((Config)proxy).isDas()) continue;
                isCurrentInstanceMatchTarget = true;
                break;
            }
        }
        if (isCurrentInstanceMatchTarget) {
            return ConfigSupport.sortAndDispatch((PropertyChangeEvent[])events, (Changed)new Changed(){

                public <T extends ConfigBeanProxy> NotProcessed changed(Changed.TYPE type, Class<T> changedType, T changedInstance) {
                    if (changedType.equals(MicroprofileConfigConfiguration.class)) {
                        ExtensionConfigSourceService.this.configuration = (MicroprofileConfigConfiguration)changedInstance;
                    }
                    return null;
                }
            }, (Logger)logger);
        }
        return null;
    }

    public void reconfigure(ConfigSourceConfiguration config) {
        for (ExtensionConfigSourceHandler handler : this.handlers) {
            Class<ConfigSourceConfiguration> configClass = handler.getConfigClass();
            if (configClass == null || !configClass.isAssignableFrom(config.getClass())) continue;
            handler.reconfigure(config);
            break;
        }
    }
}

