/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.opentracing.jaxrs.client;

import fish.payara.microprofile.opentracing.jaxrs.client.JaxrsClientDecorator;
import fish.payara.requesttracing.jaxrs.client.PayaraTracingServices;
import java.security.KeyStore;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Configuration;
import org.glassfish.jersey.client.Initializable;

class JaxrsClientBuilderDecorator
extends ClientBuilder {
    public static final String EARLY_BUILDER_INIT = "fish.payara.requesttracing.jaxrs.client.decorators.EarlyBuilderInit";
    private static final PayaraTracingServices PAYARA_SERVICES = new PayaraTracingServices();
    protected ClientBuilder clientBuilder;

    private JaxrsClientBuilderDecorator(ClientBuilder clientBuilder) {
        this.clientBuilder = clientBuilder;
    }

    public static ClientBuilder wrap(ClientBuilder clientBuilder) {
        if (clientBuilder instanceof JaxrsClientBuilderDecorator) {
            return clientBuilder;
        }
        return new JaxrsClientBuilderDecorator(clientBuilder);
    }

    public ClientBuilder withConfig(Configuration config) {
        this.clientBuilder = this.clientBuilder.withConfig(config);
        return this;
    }

    public ClientBuilder sslContext(SSLContext sslContext) {
        this.clientBuilder = this.clientBuilder.sslContext(sslContext);
        return this;
    }

    public ClientBuilder keyStore(KeyStore keyStore, char[] password) {
        this.clientBuilder = this.clientBuilder.keyStore(keyStore, password);
        return this;
    }

    public ClientBuilder trustStore(KeyStore trustStore) {
        this.clientBuilder = this.clientBuilder.trustStore(trustStore);
        return this;
    }

    public ClientBuilder hostnameVerifier(HostnameVerifier verifier) {
        this.clientBuilder = this.clientBuilder.hostnameVerifier(verifier);
        return this;
    }

    public ClientBuilder executorService(ExecutorService executorService) {
        this.clientBuilder = this.clientBuilder.executorService(executorService);
        return this;
    }

    public ClientBuilder scheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        this.clientBuilder = this.clientBuilder.scheduledExecutorService(scheduledExecutorService);
        return this;
    }

    public ClientBuilder connectTimeout(long timeout, TimeUnit unit) {
        this.clientBuilder = this.clientBuilder.connectTimeout(timeout, unit);
        return this;
    }

    public ClientBuilder readTimeout(long timeout, TimeUnit unit) {
        this.clientBuilder = this.clientBuilder.readTimeout(timeout, unit);
        return this;
    }

    public Client build() {
        if (!PAYARA_SERVICES.isTracingAvailable()) {
            return this.clientBuilder.build();
        }
        Client client = this.clientBuilder.build();
        Object earlyInit = this.getConfiguration().getProperty(EARLY_BUILDER_INIT);
        if (earlyInit instanceof Boolean && ((Boolean)earlyInit).booleanValue() && client instanceof Initializable) {
            ((Initializable)client).preInitialize();
        }
        return new JaxrsClientDecorator(client);
    }

    public Configuration getConfiguration() {
        return this.clientBuilder.getConfiguration();
    }

    public ClientBuilder property(String name, Object value) {
        this.clientBuilder = (ClientBuilder)this.clientBuilder.property(name, value);
        return this;
    }

    public ClientBuilder register(Class<?> componentClass) {
        this.clientBuilder = (ClientBuilder)this.clientBuilder.register(componentClass);
        return this;
    }

    public ClientBuilder register(Class<?> componentClass, int priority) {
        this.clientBuilder = (ClientBuilder)this.clientBuilder.register(componentClass, priority);
        return this;
    }

    public ClientBuilder register(Class<?> componentClass, Class<?> ... contracts) {
        this.clientBuilder = (ClientBuilder)this.clientBuilder.register(componentClass, (Class[])contracts);
        return this;
    }

    public ClientBuilder register(Class<?> componentClass, Map<Class<?>, Integer> contracts) {
        this.clientBuilder = (ClientBuilder)this.clientBuilder.register(componentClass, contracts);
        return this;
    }

    public ClientBuilder register(Object component) {
        this.clientBuilder = (ClientBuilder)this.clientBuilder.register(component);
        return this;
    }

    public ClientBuilder register(Object component, int priority) {
        this.clientBuilder = (ClientBuilder)this.clientBuilder.register(component, priority);
        return this;
    }

    public ClientBuilder register(Object component, Class<?> ... contracts) {
        this.clientBuilder = (ClientBuilder)this.clientBuilder.register(component, (Class[])contracts);
        return this;
    }

    public ClientBuilder register(Object component, Map<Class<?>, Integer> contracts) {
        this.clientBuilder = (ClientBuilder)this.clientBuilder.register(component, contracts);
        return this;
    }
}

