/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.monitor.jvm;

import java.lang.management.ClassLoadingMXBean;
import java.lang.management.ManagementFactory;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.external.statistics.impl.CountStatisticImpl;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;

@AMXMetadata(type="class-loading-system-mon", group="monitoring")
@ManagedObject
@Description(value="JVM Class Loading Statistics")
public class JVMClassLoadingStatsProvider {
    private final ClassLoadingMXBean clBean = ManagementFactory.getClassLoadingMXBean();
    private final CountStatisticImpl loadedClassCount = new CountStatisticImpl("LoadedClassCount", "count", "Number of classes currently loaded in the Java virtual machine");
    private final CountStatisticImpl totalLoadedClassCount = new CountStatisticImpl("TotalLoadedClassCount", "count", "Total number of classes that have been loaded since the Java virtual machine has started execution");
    private final CountStatisticImpl unloadedClassCount = new CountStatisticImpl("UnLoadedClassCount", "count", "Total number of classes unloaded since the Java virtual machine has started execution");

    @ManagedAttribute(id="loadedclass-count")
    @Description(value="number of classes currently loaded in the JVM")
    public CountStatistic getLoadedClassCount() {
        this.loadedClassCount.setCount((long)this.clBean.getLoadedClassCount());
        return this.loadedClassCount;
    }

    @ManagedAttribute(id="totalloadedclass-count")
    @Description(value="total number of classes loaded since the JVM started")
    public CountStatistic getTotalLoadedClassCount() {
        this.totalLoadedClassCount.setCount(this.clBean.getTotalLoadedClassCount());
        return this.totalLoadedClassCount;
    }

    @ManagedAttribute(id="unloadedclass-count")
    @Description(value="total number of classes unloaded since the JVM started")
    public CountStatistic getUnloadedClassCount() {
        this.unloadedClassCount.setCount(this.clBean.getUnloadedClassCount());
        return this.unloadedClassCount;
    }
}

