/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.appclient;

import com.sun.enterprise.security.common.Util;
import com.sun.enterprise.security.jaspic.AuthMessagePolicy;
import com.sun.enterprise.security.jaspic.config.ConfigParser;
import com.sun.enterprise.security.jaspic.config.GFServerConfigProvider;
import com.sun.logging.LogDomains;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.message.MessagePolicy;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.glassfish.appclient.client.acc.config.ClientContainer;
import org.glassfish.appclient.client.acc.config.MessageSecurityConfig;
import org.glassfish.appclient.client.acc.config.Property;
import org.glassfish.appclient.client.acc.config.ProviderConfig;
import org.glassfish.appclient.client.acc.config.RequestPolicy;
import org.glassfish.appclient.client.acc.config.ResponsePolicy;
import org.glassfish.internal.api.Globals;
import sun.security.util.PropertyExpander;

public class ConfigXMLParser
implements ConfigParser {
    private static Logger _logger = null;
    private Map configMap = new HashMap();
    private Set<String> layersWithDefault = new HashSet<String>();
    private List<MessageSecurityConfig> msgSecConfigs = null;
    private static final String ACC_XML = "glassfish-acc.xml.url";

    public void initialize(List<MessageSecurityConfig> msgConfigs) throws IOException {
        this.msgSecConfigs = msgConfigs;
        if (this.msgSecConfigs != null) {
            this.processClientConfigContext(this.configMap);
        }
    }

    private void processClientConfigContext(Map newConfig) throws IOException {
        String intercept = null;
        List<MessageSecurityConfig> msgConfigs = this.msgSecConfigs;
        assert (msgConfigs != null);
        for (MessageSecurityConfig config : msgConfigs) {
            intercept = this.parseInterceptEntry(config, newConfig);
            List pConfigs = config.getProviderConfig();
            for (ProviderConfig pConfig : pConfigs) {
                this.parseIDEntry(pConfig, newConfig, intercept);
            }
        }
    }

    public Map getConfigMap() {
        return this.configMap;
    }

    public Set<String> getLayersWithDefault() {
        return this.layersWithDefault;
    }

    private String parseInterceptEntry(MessageSecurityConfig msgConfig, Map newConfig) throws IOException {
        GFServerConfigProvider.InterceptEntry intEntry;
        String intercept = null;
        String defaultServerID = null;
        String defaultClientID = null;
        MessageSecurityConfig clientMsgSecConfig = msgConfig;
        intercept = clientMsgSecConfig.getAuthLayer();
        defaultServerID = clientMsgSecConfig.getDefaultProvider();
        defaultClientID = clientMsgSecConfig.getDefaultClientProvider();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Intercept Entry: \n    intercept: " + intercept + "\n    defaultServerID: " + defaultServerID + "\n    defaultClientID:  " + defaultClientID);
        }
        if (defaultServerID != null || defaultClientID != null) {
            this.layersWithDefault.add(intercept);
        }
        if ((intEntry = (GFServerConfigProvider.InterceptEntry)newConfig.get(intercept)) != null) {
            throw new IOException("found multiple MessageSecurityConfig entries with the same auth-layer");
        }
        intEntry = new GFServerConfigProvider.InterceptEntry(defaultClientID, defaultServerID, null);
        newConfig.put(intercept, intEntry);
        return intercept;
    }

    private void parseIDEntry(ProviderConfig pConfig, Map newConfig, String intercept) throws IOException {
        String id = pConfig.getProviderId();
        String type = pConfig.getProviderType();
        String moduleClass = pConfig.getClassName();
        MessagePolicy requestPolicy = this.parsePolicy(pConfig.getRequestPolicy());
        MessagePolicy responsePolicy = this.parsePolicy(pConfig.getResponsePolicy());
        HashMap<String, String> options = new HashMap<String, String>();
        List props = pConfig.getProperty();
        for (Property prop : props) {
            try {
                options.put(prop.getName(), PropertyExpander.expand(prop.getValue(), false));
            }
            catch (PropertyExpander.ExpandException ee) {
                if (_logger.isLoggable(Level.WARNING)) {
                    _logger.warning("jaspic.unexpandedproperty");
                }
                options.put(prop.getName(), prop.getValue());
            }
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ID Entry: \n    module class: " + moduleClass + "\n    id: " + id + "\n    type: " + type + "\n    request policy: " + requestPolicy + "\n    response policy: " + responsePolicy + "\n    options: " + options);
        }
        GFServerConfigProvider.IDEntry idEntry = new GFServerConfigProvider.IDEntry(type, moduleClass, requestPolicy, responsePolicy, options);
        GFServerConfigProvider.InterceptEntry intEntry = (GFServerConfigProvider.InterceptEntry)newConfig.get(intercept);
        if (intEntry == null) {
            throw new IOException("intercept entry for " + intercept + " must be specified before ID entries");
        }
        if (intEntry.getIdMap() == null) {
            intEntry.setIdMap(new HashMap());
        }
        intEntry.getIdMap().put(id, idEntry);
    }

    private MessagePolicy parsePolicy(Object policy) {
        if (policy == null) {
            return null;
        }
        String authSource = null;
        String authRecipient = null;
        if (policy instanceof RequestPolicy) {
            RequestPolicy clientRequestPolicy = (RequestPolicy)policy;
            authSource = clientRequestPolicy.getAuthSource();
            authRecipient = clientRequestPolicy.getAuthRecipient();
        } else if (policy instanceof ResponsePolicy) {
            ResponsePolicy clientResponsePolicy = (ResponsePolicy)policy;
            authSource = clientResponsePolicy.getAuthSource();
            authRecipient = clientResponsePolicy.getAuthRecipient();
        }
        return AuthMessagePolicy.getMessagePolicy((String)authSource, authRecipient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(Object config) throws IOException {
        String sun_acc = System.getProperty(ACC_XML, "glassfish-acc.xml");
        List msgconfigs = null;
        if (Globals.getDefaultHabitat() == null && sun_acc != null) {
            try (FileInputStream is = null;){
                is = new FileInputStream(sun_acc);
                JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{ClientContainer.class});
                Unmarshaller u = jc.createUnmarshaller();
                ClientContainer cc = (ClientContainer)u.unmarshal((InputStream)is);
                msgconfigs = cc.getMessageSecurityConfig();
            }
        } else {
            Util util = Util.getInstance();
            assert (util != null);
            msgconfigs = (List)util.getAppClientMsgSecConfigs();
        }
        this.initialize(msgconfigs);
    }

    static {
        _logger = LogDomains.getLogger(ConfigXMLParser.class, (String)"javax.enterprise.system.core.security");
    }
}

