/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gjc.spi.jdbc40;

import com.sun.gjc.spi.JdbcObjectsFactory;
import com.sun.gjc.spi.ManagedConnectionFactoryImpl;
import com.sun.gjc.spi.ManagedConnectionImpl;
import com.sun.gjc.spi.base.ConnectionHolder;
import com.sun.gjc.spi.jdbc40.ConnectionHolder40;
import com.sun.gjc.spi.jdbc40.ConnectionWrapper40;
import com.sun.gjc.spi.jdbc40.DataSource40;
import com.sun.gjc.spi.jdbc40.ProfiledConnectionWrapper40;
import com.sun.gjc.util.SQLTraceDelegator;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.util.logging.Level;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.sql.DataSource;

public class Jdbc40ObjectsFactory
extends JdbcObjectsFactory {
    private boolean jdbc30Connection;
    private boolean initJDBC30Connection;

    @Override
    public ConnectionHolder getConnection(Connection conObject, ManagedConnectionImpl mcObject, ConnectionRequestInfo criObject, boolean statementWrapping, SQLTraceDelegator sqlTraceDelegator) {
        ConnectionHolder40 connection = null;
        if (!this.initJDBC30Connection) {
            this.detectJDBC30Connection(conObject, mcObject);
        }
        if (statementWrapping) {
            if (sqlTraceDelegator != null) {
                Class[] connIntf = new Class[]{Connection.class};
                Connection proxiedConn = this.getProxiedConnection(conObject, connIntf, sqlTraceDelegator);
                connection = new ProfiledConnectionWrapper40(proxiedConn, mcObject, criObject, this.jdbc30Connection, sqlTraceDelegator);
            } else {
                connection = new ConnectionWrapper40(conObject, mcObject, criObject, this.jdbc30Connection);
            }
        } else {
            connection = new ConnectionHolder40(conObject, mcObject, criObject, this.jdbc30Connection);
        }
        return connection;
    }

    @Override
    public DataSource getDataSourceInstance(ManagedConnectionFactoryImpl mcfObject, ConnectionManager cmObject) {
        return new DataSource40(mcfObject, cmObject);
    }

    public boolean isJdbc30Connection() {
        return this.jdbc30Connection;
    }

    public void setJdbc30Connection(boolean jdbc30Connection) {
        this.jdbc30Connection = jdbc30Connection;
    }

    public boolean isJDBC30ConnectionDetected() {
        return this.initJDBC30Connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detectJDBC30Connection(Connection con, ManagedConnectionImpl mcObject) {
        String dataSourceProperty = mcObject.getManagedConnectionFactory().getJdbc30DataSource();
        if (dataSourceProperty != null) {
            this.setJdbc30Connection(Boolean.valueOf(dataSourceProperty));
            this.initJDBC30Connection = true;
        } else {
            try {
                Class[] paramClasses = new Class[]{Class.class};
                Method isWrapperMethod = con.getClass().getMethod("isWrapperFor", paramClasses);
                int modifiers = isWrapperMethod.getModifiers();
                this.setJdbc30Connection(Modifier.isAbstract(modifiers));
            }
            catch (AbstractMethodError | NoSuchMethodException e) {
                this.setJdbc30Connection(true);
            }
            catch (Throwable t) {
                this.setJdbc30Connection(true);
                _logger.log(Level.WARNING, "jdbc.unexpected_exception_on_detecting_jdbc_version", t);
            }
            finally {
                this.initJDBC30Connection = true;
            }
        }
    }
}

