/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.microprofile.restclient;

import java.net.URI;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.jersey.client.JerseyClient;
import org.glassfish.jersey.client.JerseyInvocation;
import org.glassfish.jersey.client.JerseyWebTarget;
import org.glassfish.jersey.internal.util.collection.UnsafeValue;
import org.glassfish.jersey.microprofile.restclient.RestClientWebTarget;
import org.glassfish.jersey.microprofile.restclient.internal.LocalizationMessages;

public class JerseyRestClient
extends JerseyClient {
    protected JerseyRestClient(Configuration config, SSLContext sslContext, HostnameVerifier verifier) {
        super(config, sslContext, verifier, null);
    }

    protected JerseyRestClient(Configuration config, UnsafeValue<SSLContext, IllegalStateException> sslContextProvider, HostnameVerifier verifier) {
        super(config, sslContextProvider, verifier, null);
    }

    public JerseyWebTarget target(String uri) {
        this.checkNotClosed();
        JerseyRestClient.checkNotNull(uri, LocalizationMessages.CLIENT_URI_TEMPLATE_NULL());
        return new RestClientWebTarget(uri, (JerseyClient)this);
    }

    public JerseyWebTarget target(URI uri) {
        this.checkNotClosed();
        JerseyRestClient.checkNotNull(uri, LocalizationMessages.CLIENT_URI_NULL());
        return new RestClientWebTarget(uri, (JerseyClient)this);
    }

    public JerseyWebTarget target(UriBuilder uriBuilder) {
        this.checkNotClosed();
        JerseyRestClient.checkNotNull(uriBuilder, LocalizationMessages.CLIENT_URI_BUILDER_NULL());
        return new RestClientWebTarget(uriBuilder, (JerseyClient)this);
    }

    public JerseyWebTarget target(Link link) {
        this.checkNotClosed();
        JerseyRestClient.checkNotNull(link, LocalizationMessages.CLIENT_TARGET_LINK_NULL());
        return new RestClientWebTarget(link, (JerseyClient)this);
    }

    public JerseyInvocation.Builder invocation(Link link) {
        this.checkNotClosed();
        JerseyRestClient.checkNotNull(link, LocalizationMessages.CLIENT_INVOCATION_LINK_NULL());
        RestClientWebTarget t = new RestClientWebTarget(link, (JerseyClient)this);
        String acceptType = link.getType();
        return acceptType != null ? t.request(new String[]{acceptType}) : t.request();
    }

    public static <T> T checkNotNull(T reference, Object errorMessage) {
        if (reference == null) {
            throw new NullPointerException(String.valueOf(errorMessage));
        }
        return reference;
    }
}

