/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.openapi.impl.model.security;

import fish.payara.microprofile.openapi.api.visitor.ApiContext;
import fish.payara.microprofile.openapi.impl.model.util.ModelUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.security.SecurityRequirement;
import org.glassfish.hk2.classmodel.reflect.AnnotationModel;

public class SecurityRequirementImpl
extends LinkedHashMap<String, List<String>>
implements SecurityRequirement {
    private static final long serialVersionUID = -677783376083861245L;

    public static SecurityRequirement createInstance(AnnotationModel annotation, ApiContext context) {
        SecurityRequirementImpl from = new SecurityRequirementImpl();
        String name = (String)annotation.getValue("name", String.class);
        List scopes = (List)annotation.getValue("scopes", List.class);
        from.addScheme(name, scopes != null ? scopes : Collections.emptyList());
        return from;
    }

    public SecurityRequirementImpl() {
    }

    public SecurityRequirementImpl(Map<? extends String, ? extends List<String>> items) {
        super(items);
    }

    public SecurityRequirement addScheme(String name, String item) {
        this.put(name, item == null ? ModelUtils.createList() : Arrays.asList(item));
        return this;
    }

    public SecurityRequirement addScheme(String name, List<String> item) {
        this.put(name, item == null ? ModelUtils.createList() : item);
        return this;
    }

    public SecurityRequirement addScheme(String name) {
        this.put(name, ModelUtils.createList());
        return this;
    }

    public void removeScheme(String securitySchemeName) {
        this.remove(securitySchemeName);
    }

    public Map<String, List<String>> getSchemes() {
        return ModelUtils.readOnlyView(this);
    }

    public void setSchemes(Map<String, List<String>> items) {
        this.clear();
        this.putAll(items);
    }

    public static void merge(SecurityRequirement from, SecurityRequirement to) {
        if (from == null) {
            return;
        }
        for (String name : from.getSchemes().keySet()) {
            if (name == null || name.isEmpty()) continue;
            to.addScheme(name, (List)from.getSchemes().get(name));
        }
    }
}

