/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.server.core.jws;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import org.glassfish.appclient.server.core.jws.LoaderConfigContent;
import org.glassfish.appclient.server.core.jws.RestrictedContentAdapter;
import org.glassfish.appclient.server.core.jws.Util;
import org.glassfish.appclient.server.core.jws.servedcontent.ACCConfigContent;
import org.glassfish.appclient.server.core.jws.servedcontent.DynamicContent;
import org.glassfish.appclient.server.core.jws.servedcontent.StaticContent;
import org.glassfish.enterprise.iiop.api.GlassFishORBFactory;
import org.glassfish.grizzly.http.Method;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.http.server.Session;
import org.glassfish.orb.admin.config.IiopListener;
import org.glassfish.orb.admin.config.IiopService;

public class AppClientHTTPAdapter
extends RestrictedContentAdapter {
    public static final String GF_JWS_SESSION_CACHED_JNLP_NAME = "org.glassfish.jws.mainJNLP";
    public static final String GF_JWS_SESSION_IS_MAIN_PROCESSED_NAME = "org.glassfish.jws.isMainProcessed";
    private static final String IF_UNMODIFIED_SINCE = "If-Unmodified-Since";
    private static final String ARG_QUERY_PARAM_NAME = "arg";
    private static final String PROP_QUERY_PARAM_NAME = "prop";
    private static final String VMARG_QUERY_PARAM_NAME = "vmarg";
    private static final String ACC_ARG_QUERY_PARAM_NAME = "accarg";
    private static final String JWS_ARG_QUERY_PARAM_NAME = "jwsaccarg";
    private static final String DEFAULT_ORB_LISTENER_ID = "orb-listener-1";
    private static final String LINE_SEP = System.getProperty("line.separator");
    private static final String NEW_LINE = "\r\n";
    private final Map<String, DynamicContent> dynamicContent;
    private final Properties tokens;
    private final IiopService iiopService;
    private final GlassFishORBFactory orbFactory;
    private final ACCConfigContent accConfigContent;
    private final LoaderConfigContent loaderConfigContent;

    public static URI requestURI(Request gReq) throws URISyntaxException {
        return new URI(gReq.getScheme(), null, gReq.getLocalName(), gReq.getLocalPort(), gReq.getPathInfo(), gReq.getQueryString(), null);
    }

    public AppClientHTTPAdapter(String contextRoot, Properties tokens, File domainDir, File installDir, IiopService iiopService, GlassFishORBFactory orbFactory) throws IOException {
        this(contextRoot, new HashMap<String, StaticContent>(), new HashMap<String, DynamicContent>(), tokens, domainDir, installDir, iiopService, orbFactory);
    }

    public AppClientHTTPAdapter(String contextRoot, Map<String, StaticContent> staticContent, Map<String, DynamicContent> dynamicContent, Properties tokens, File domainDir, File installDir, IiopService iiopService, GlassFishORBFactory orbFactory) throws IOException {
        super(contextRoot, staticContent);
        this.dynamicContent = dynamicContent;
        this.tokens = tokens;
        this.iiopService = iiopService;
        this.orbFactory = orbFactory;
        this.accConfigContent = new ACCConfigContent(new File(domainDir, "config"), new File(new File(installDir, "lib"), "appclient"));
        this.loaderConfigContent = new LoaderConfigContent(installDir);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.dumpContent(this.dynamicContent));
        }
    }

    @Override
    public void service(Request gReq, Response gResp) {
        if (logger.isLoggable(Level.FINER)) {
            this.dumpHeaders(gReq);
        }
        String savedRequestURI = gReq.getRequestURI();
        Session s = gReq.getSession(false);
        logger.log(Level.FINE, "Req " + savedRequestURI + ", session was " + (s == null ? "NONE" : s.getIdInternal() + ":" + s.getSessionTimeout()));
        String relativeURIString = this.relativizeURIString(this.contextRoot(), savedRequestURI);
        if (relativeURIString == null) {
            this.respondNotFound(gResp);
        } else {
            if (this.dynamicContent.containsKey(relativeURIString)) {
                try {
                    this.processDynamicContent(this.tokens, relativeURIString, gReq, gResp);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
                catch (URISyntaxException ex) {
                    throw new RuntimeException(ex);
                }
                finally {
                    if (logger.isLoggable(Level.FINER)) {
                        this.dumpHeaders(gResp, savedRequestURI);
                    }
                }
            }
            try {
                if (!this.serviceContent(gReq, gResp)) {
                    this.respondNotFound(gResp);
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            finally {
                if (logger.isLoggable(Level.FINER)) {
                    this.dumpHeaders(gResp, savedRequestURI);
                }
            }
        }
    }

    private void dumpHeaders(Response gResp, String savedRequestURI) {
        if (logger.isLoggable(Level.FINER)) {
            StringBuilder sb = new StringBuilder();
            sb.append("JWS response for URI=").append(savedRequestURI).append(", status=").append(gResp.getStatus()).append(LINE_SEP);
            for (String headerName : gResp.getHeaderNames()) {
                String header = gResp.getHeader(headerName);
                sb.append("  ").append(headerName).append("=").append(header).append(LINE_SEP);
            }
            logger.log(Level.FINER, sb.toString());
        }
    }

    private void dumpHeaders(Request gReq) {
        StringBuilder sb = new StringBuilder();
        sb.append("JWS request: method=").append(gReq.getMethod().toString()).append(", URI=").append(gReq.getRequestURI()).append(LINE_SEP);
        for (String headerName : gReq.getHeaderNames()) {
            String header = gReq.getHeader(headerName);
            sb.append("  ").append(headerName).append("=").append(header).append(LINE_SEP);
        }
        logger.log(Level.FINER, sb.toString());
    }

    public void addContentIfAbsent(Map<String, StaticContent> staticAdditions, Map<String, DynamicContent> dynamicAdditions) throws IOException {
        this.addContentIfAbsent(staticAdditions);
        this.addDynamicContentIfAbsent(dynamicAdditions);
    }

    private void addDynamicContentIfAbsent(Map<String, DynamicContent> additions) {
        for (Map.Entry<String, DynamicContent> entry : additions.entrySet()) {
            this.addContentIfAbsent(entry.getKey(), entry.getValue());
        }
    }

    private void addContentIfAbsent(String relativeURIString, DynamicContent addition) {
        if (!this.dynamicContent.containsKey(relativeURIString)) {
            this.dynamicContent.put(relativeURIString, addition);
        }
    }

    private void processDynamicContent(Properties tokens, String relativeURIString, Request gReq, Response gResp) throws IOException, URISyntaxException {
        Method methodType;
        DynamicContent dc = this.dynamicContent.get(relativeURIString);
        if (dc == null) {
            this.respondNotFound(gResp);
            logger.log(Level.FINE, "{0} Could not find dynamic content requested using {1}", new Object[]{this.logPrefix(), relativeURIString});
            return;
        }
        URI requestURI = AppClientHTTPAdapter.requestURI(gReq);
        if (!dc.isAvailable(requestURI)) {
            this.finishErrorResponse(gResp, this.contentStateToResponseStatus(dc, requestURI));
            logger.log(Level.FINE, "{0} Found dynamic content ({1} but is is not marked as available", new Object[]{this.logPrefix(), relativeURIString});
            return;
        }
        Properties allTokens = null;
        try {
            allTokens = this.prepareRequestPlaceholders(tokens, gReq);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "prepareRequestPlaceholder", e);
            this.finishErrorResponse(gResp, 500);
        }
        DynamicContent.Instance instance = dc.getOrCreateInstance(allTokens);
        Date instanceTimestamp = instance.getTimestamp();
        if (this.returnIfClientCacheIsCurrent(relativeURIString, gReq, instanceTimestamp.getTime())) {
            return;
        }
        gResp.setDateHeader("Last-Modified", instanceTimestamp.getTime());
        gResp.setDateHeader("Date", System.currentTimeMillis());
        gResp.setContentType(dc.getMimeType());
        gResp.setStatus(200);
        String text = instance.getText();
        if (dc.isMain()) {
            this.saveJNLPWithSession(gReq, text, requestURI);
        }
        if (Method.GET.equals(methodType = gReq.getMethod())) {
            this.writeData(text, gReq.getResponse());
        }
        logger.log(Level.FINE, "{0}Served dyn content for {1}: {2}{3}", new Object[]{this.logPrefix(), methodType, relativeURIString, logger.isLoggable(Level.FINEST) ? "->" + instance.getText() : ""});
        this.finishResponse(gResp, 200);
    }

    private void saveJNLPWithSession(Request gReq, String text, URI requestURI) {
        Session session = gReq.getSession();
        Boolean isMainJNLPProcessed = AppClientHTTPAdapter.booleanAttr(session.getAttribute(GF_JWS_SESSION_IS_MAIN_PROCESSED_NAME));
        if (!isMainJNLPProcessed.booleanValue()) {
            byte[] jnlp = text.getBytes();
            session.setAttribute(GF_JWS_SESSION_IS_MAIN_PROCESSED_NAME, (Object)Boolean.TRUE);
            session.setAttribute(GF_JWS_SESSION_CACHED_JNLP_NAME, (Object)jnlp);
            logger.log(Level.FINE, "Session {1} contains no GF/JWS attr; caching {0} and setting attr to main JNLP content", new Object[]{requestURI, session.getIdInternal()});
        } else {
            logger.log(Level.FINE, "Session {0} already contains cached JNLP", session.getIdInternal());
        }
    }

    public static Boolean booleanAttr(Object attrValue) {
        if (attrValue == null) {
            return false;
        }
        if (!(attrValue instanceof Boolean)) {
            return false;
        }
        return (Boolean)attrValue;
    }

    private Properties prepareRequestPlaceholders(Properties adapterTokens, Request request) throws FileNotFoundException, IOException {
        Properties answer = new Properties(adapterTokens);
        answer.setProperty("request.scheme", request.getScheme());
        answer.setProperty("request.host", request.getServerName());
        answer.setProperty("request.port", Integer.toString(request.getServerPort()));
        answer.setProperty("request.adapter.context.root", this.contextRoot());
        answer.setProperty("request.glassfish-acc.xml.content", Util.toXMLEscaped(this.accConfigContent.sunACC()));
        answer.setProperty("request.appclient.login.conf.content", Util.toXMLEscaped(this.accConfigContent.appClientLogin()));
        answer.setProperty("request.message.security.config.provider.security.config", Util.toXMLEscaped(this.accConfigContent.securityConfig()));
        answer.setProperty("loader.config", Util.toXMLEscaped(this.loaderConfigContent.content()));
        String queryString = request.getQueryString();
        StringBuilder queryStringPropValue = new StringBuilder();
        if (queryString != null && queryString.length() > 0) {
            queryStringPropValue.append("?").append(queryString);
        }
        answer.setProperty("request.quoted.query.string", Util.toXMLEscapedInclAmp(queryStringPropValue.toString()));
        this.processQueryParameters(queryString, answer);
        return answer;
    }

    private String targetServerSetting(Properties props) {
        String result = null;
        try {
            result = this.orbFactory.getIIOPEndpoints();
        }
        catch (NullPointerException npe) {
            String port = null;
            for (IiopListener listener : this.iiopService.getIiopListener()) {
                if (!listener.getId().equals(DEFAULT_ORB_LISTENER_ID)) continue;
                port = listener.getPort();
                break;
            }
            result = props.getProperty("request.host") + ":" + port;
        }
        return result;
    }

    private void processQueryParameters(String queryString, Properties answer) {
        if (queryString == null) {
            queryString = "";
        }
        String[] queryParams = null;
        try {
            queryParams = URLDecoder.decode(queryString, "UTF-8").split("&");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        ArgQueryParams arguments = new ArgQueryParams();
        PropQueryParams properties = new PropQueryParams();
        VMArgQueryParams vmArguments = new VMArgQueryParams();
        ACCArgQueryParams accArguments = new ACCArgQueryParams(this.targetServerSetting(answer));
        JWSACCArgQueryParams jwsaccArguments = new JWSACCArgQueryParams();
        QueryParams[] paramTypes = new QueryParams[]{arguments, properties, vmArguments, accArguments, jwsaccArguments};
        for (String param : queryParams) {
            for (QueryParams qpType : paramTypes) {
                if (qpType.processParameter(param)) break;
            }
        }
        answer.setProperty("request.arguments", ((QueryParams)arguments).toString());
        answer.setProperty("request.properties", ((QueryParams)properties).toString());
        answer.setProperty("request.vmargs", ((QueryParams)vmArguments).toString());
        answer.setProperty("request.extra.agent.args", ((QueryParams)accArguments).toString());
        answer.setProperty("request.javaws.acc.properties", ((QueryParams)jwsaccArguments).toString());
    }

    private void writeData(String data, Response res) {
        try {
            res.setStatus(200);
            res.setContentLength(data.length());
            res.flush();
            Writer pw = res.getWriter();
            pw.write(data);
            pw.write(NEW_LINE);
            pw.flush();
        }
        catch (Exception e) {
            res.setStatus(500);
            res.setError();
            return;
        }
    }

    private String commaIfNeeded(int origLength) {
        return origLength > 0 ? "," : "";
    }

    protected String dumpContent(Map<String, DynamicContent> dc) {
        if (dc == null) {
            return "   Dynamic content: not initialized";
        }
        if (dc.isEmpty()) {
            return "  Dynamic content: empty" + LINE_SEP;
        }
        StringBuilder sb = new StringBuilder("  Dynamic content:");
        for (Map.Entry<String, DynamicContent> entry : dc.entrySet()) {
            sb.append("  ").append(entry.getKey());
            if (!logger.isLoggable(Level.FINER)) continue;
            sb.append("  ====").append(LINE_SEP).append(entry.getValue().toString()).append("  ====").append(LINE_SEP);
        }
        sb.append("  ========");
        return sb.toString();
    }

    private class VMArgQueryParams
    extends QueryParams {
        private StringBuilder vmArgs;

        public VMArgQueryParams() {
            super(AppClientHTTPAdapter.VMARG_QUERY_PARAM_NAME);
            this.vmArgs = new StringBuilder();
        }

        @Override
        public void processValue(String value) {
            this.vmArgs.append(value).append(" ");
        }

        @Override
        public String toString() {
            return this.vmArgs.length() > 0 ? " java-vm=args=\"" + this.vmArgs.toString() + "\"" : "";
        }
    }

    private class PropQueryParams
    extends QueryParams {
        private StringBuilder properties;

        public PropQueryParams() {
            super(AppClientHTTPAdapter.PROP_QUERY_PARAM_NAME);
            this.properties = new StringBuilder();
        }

        @Override
        public void processValue(String value) {
            if (value.length() > 0) {
                int equalsSign = value.indexOf(61);
                String propValue = "";
                if (equalsSign > 0) {
                    String propName = value.substring(0, equalsSign);
                    if (equalsSign + 1 < value.length()) {
                        propValue = value.substring(equalsSign + 1);
                    }
                    this.properties.append("<property name=\"").append(propName).append("\" value=\"").append(propValue).append("\"/>").append(LINE_SEP);
                }
            }
        }

        @Override
        public String toString() {
            return this.properties.toString();
        }
    }

    private class JWSACCArgQueryParams
    extends QueryParams {
        private static final String JWS_ACC_PROPERTY_PREFIX = "javaws.acc.";
        private final Properties props;

        private JWSACCArgQueryParams() {
            super(AppClientHTTPAdapter.JWS_ARG_QUERY_PARAM_NAME);
            this.props = new Properties();
        }

        @Override
        protected void processValue(String value) {
            int equals = value.indexOf(61);
            String propName = equals == -1 ? value : value.substring(1, equals);
            String propValue = equals == -1 ? "" : value.substring(equals + 1);
            this.props.setProperty(propName, propValue);
        }

        @Override
        public String toString() {
            int slot = 0;
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<Object, Object> entry : this.props.entrySet()) {
                sb.append("<property name=\"").append(JWS_ACC_PROPERTY_PREFIX).append(slot++).append("\" value=\"").append((String)entry.getKey()).append("=").append((String)entry.getValue()).append("\"/>").append(LINE_SEP);
            }
            return sb.toString();
        }
    }

    private class ACCArgQueryParams
    extends QueryParams {
        private StringBuilder settings;
        private final String targetServerSetting;

        public ACCArgQueryParams(String targetServerSetting) {
            super(AppClientHTTPAdapter.ACC_ARG_QUERY_PARAM_NAME);
            this.settings = new StringBuilder();
            this.targetServerSetting = "arg=-targetserver,arg=" + targetServerSetting;
        }

        @Override
        public void processValue(String value) {
            this.settings.append(AppClientHTTPAdapter.this.commaIfNeeded(this.settings.length())).append("arg=").append(value);
        }

        @Override
        public String toString() {
            return this.settings.toString() + AppClientHTTPAdapter.this.commaIfNeeded(this.settings.length()) + this.targetServerSetting;
        }
    }

    private class ArgQueryParams
    extends QueryParams {
        private StringBuilder arguments;

        public ArgQueryParams() {
            super(AppClientHTTPAdapter.ARG_QUERY_PARAM_NAME);
            this.arguments = new StringBuilder();
        }

        @Override
        public void processValue(String value) {
            if (value.length() == 0) {
                value = "#missing#";
            }
            this.arguments.append("<argument>").append(value).append("</argument>").append(LINE_SEP);
        }

        @Override
        public String toString() {
            return this.arguments.toString();
        }
    }

    private abstract class QueryParams {
        private String prefix;

        protected QueryParams(String prefix) {
            this.prefix = prefix;
        }

        private boolean handles(String prefix) {
            return prefix.equals(this.prefix);
        }

        protected abstract void processValue(String var1);

        public abstract String toString();

        public boolean processParameter(String param) {
            boolean result = false;
            int equalsSign = param.indexOf(61);
            String value = "";
            String paramPrefix = equalsSign != -1 ? param.substring(0, equalsSign) : param;
            if (this.handles(paramPrefix)) {
                result = true;
                if (equalsSign + 1 < param.length()) {
                    value = param.substring(equalsSign + 1);
                }
                this.processValue(value);
            }
            return result;
        }
    }
}

