/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.loader;

import com.sun.enterprise.loader.WatchProcessor;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;

class ItemChecker
extends WatchProcessor {
    private Set<String> prefixes = new HashSet<String>();
    private static final int WALK_DEPTH = 3;
    private boolean lateRegistration;

    protected ItemChecker(Path root, WatchService watchService) {
        super(root, watchService);
    }

    @Override
    protected void register() {
        if (this.registered) {
            return;
        }
        try {
            this.prefixes = AccessController.doPrivileged(this::readPrefixes);
            if (this.prefixes.isEmpty()) {
                LOGGER.fine(() -> "Registering watch for " + this.root);
            } else {
                LOGGER.fine(() -> "Will lookup classes in " + this.root + " for " + this.prefixes);
            }
            this.registered = true;
            if (this.prefixes.isEmpty() || this.lateRegistration) {
                this.registerFilesystemWatch();
            }
        }
        catch (PrivilegedActionException e) {
            LOGGER.log(Level.WARNING, e, () -> "Failed to register watcher for " + this.root);
        }
    }

    private void registerLater() {
        this.lateRegistration = true;
    }

    Set<String> readPrefixes() throws IOException {
        final HashSet prefixPaths = new HashSet();
        final int level0 = this.root.getNameCount();
        Files.walkFileTree(this.root, Collections.emptySet(), 4, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (attrs.isRegularFile()) {
                    Path target = file.getParent().equals(ItemChecker.this.root) ? file : file.getParent();
                    prefixPaths.add(target);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                if (dir.getNameCount() - level0 == 3) {
                    prefixPaths.add(dir);
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return prefixPaths.stream().map(path -> this.root.relativize((Path)path)).map(path -> path.toString().replace('\\', '/')).collect(Collectors.toSet());
    }

    @Override
    protected boolean created(Path filename) {
        LOGGER.fine(() -> this.root.toAbsolutePath() + ": " + filename + " created");
        this.prefixes.add(filename.toString());
        return true;
    }

    public boolean hasItem(String item) {
        return this.registered && (this.overflowed || this.prefixes.stream().anyMatch(prefix -> item.startsWith((String)prefix)));
    }

    static ItemChecker registerExisting(Path root, WatchService watchService) {
        ItemChecker resolver = new ItemChecker(root, watchService);
        resolver.register();
        return resolver;
    }

    static ItemChecker registerNonExisting(Path root, WatchService watchService) {
        ItemChecker resolver = new ItemChecker(root, watchService);
        resolver.registerLater();
        return resolver;
    }
}

