/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.resources.custom;

import com.sun.enterprise.server.logging.logviewer.backend.LogFilter;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.glassfish.admin.rest.logviewer.LogRecord;
import org.glassfish.admin.rest.logviewer.LogRecordList;
import org.glassfish.admin.rest.resources.custom.LogNamesResource;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.api.LogManager;

public class StructuredLogViewerResource {
    protected ServiceLocator habitat = Globals.getDefaultBaseServiceLocator();
    @Context
    protected ServiceLocator injector;

    @Path(value="lognames/")
    public LogNamesResource getLogNamesResource() {
        return (LogNamesResource)this.injector.createAndInitialize(LogNamesResource.class);
    }

    @GET
    @Produces(value={"application/json", "application/xml"})
    public LogRecordList getRecords(@QueryParam(value="logFileName") @DefaultValue(value="${com.sun.aas.instanceRoot}/logs/server.log") String logFileName, @QueryParam(value="startIndex") @DefaultValue(value="-1") long startIndex, @QueryParam(value="searchForward") @DefaultValue(value="false") boolean searchForward, @QueryParam(value="maximumNumberOfResults") @DefaultValue(value="40") int maximumNumberOfResults, @QueryParam(value="onlyLevel") @DefaultValue(value="false") boolean onlyLevel, @QueryParam(value="fromTime") @DefaultValue(value="-1") long fromTime, @QueryParam(value="toTime") @DefaultValue(value="-1") long toTime, @QueryParam(value="logLevel") @DefaultValue(value="INFO") String logLevel, @QueryParam(value="anySearch") @DefaultValue(value="") String anySearch, @QueryParam(value="listOfModules") String listOfModules, @QueryParam(value="instanceName") @DefaultValue(value="") String instanceName) throws IOException {
        return this.getWithType(logFileName, startIndex, searchForward, maximumNumberOfResults, fromTime, toTime, logLevel, onlyLevel, anySearch, listOfModules, instanceName);
    }

    private LogRecordList getWithType(String logFileName, long startIndex, boolean searchForward, int maximumNumberOfResults, long fromTime, long toTime, String logLevel, boolean onlyLevel, String anySearch, String listOfModules, String instanceName) throws IOException {
        if (this.habitat.getService(LogManager.class, new Annotation[0]) == null) {
            throw new IOException("The GlassFish LogManager Service is not available. Not installed?");
        }
        ArrayList<String> modules = new ArrayList<String>();
        if (listOfModules != null && !listOfModules.isEmpty()) {
            modules.addAll(Arrays.asList(listOfModules.split(",")));
        }
        Properties nameValueMap = new Properties();
        boolean sortAscending = true;
        if (!searchForward) {
            sortAscending = false;
        }
        LogFilter logFilter = (LogFilter)this.habitat.getService(LogFilter.class, new Annotation[0]);
        if (instanceName.equals("")) {
            AttributeList result = logFilter.getLogRecordsUsingQuery(logFileName, Long.valueOf(startIndex), Boolean.valueOf(searchForward), Boolean.valueOf(sortAscending), Integer.valueOf(maximumNumberOfResults), fromTime == -1L ? null : new Date(fromTime), toTime == -1L ? null : new Date(toTime), logLevel, Boolean.valueOf(onlyLevel), modules, nameValueMap, anySearch);
            return this.convertQueryResult(result);
        }
        AttributeList result = logFilter.getLogRecordsUsingQuery(logFileName, Long.valueOf(startIndex), Boolean.valueOf(searchForward), Boolean.valueOf(sortAscending), Integer.valueOf(maximumNumberOfResults), fromTime == -1L ? null : new Date(fromTime), toTime == -1L ? null : new Date(toTime), logLevel, Boolean.valueOf(onlyLevel), modules, nameValueMap, anySearch, instanceName);
        return this.convertQueryResult(result);
    }

    private LogRecordList convertQueryResult(AttributeList queryResult) {
        LogRecordList records = new LogRecordList();
        if (!queryResult.isEmpty()) {
            AttributeList fieldAttrs = (AttributeList)((Attribute)queryResult.get(0)).getValue();
            String[] fieldHeaders = new String[fieldAttrs.size()];
            for (int i = 0; i < fieldHeaders.length; ++i) {
                Attribute attr = (Attribute)fieldAttrs.get(i);
                fieldHeaders[i] = (String)attr.getValue();
            }
            List srcRecords = (List)List.class.cast(((Attribute)queryResult.get(1)).getValue());
            for (int recordIdx = 0; recordIdx < srcRecords.size(); ++recordIdx) {
                List record = (List)srcRecords.get(recordIdx);
                assert (record.size() == fieldHeaders.length);
                LogRecord rec = new LogRecord();
                int fieldIdx = 0;
                rec.setRecordNumber((Long)record.get(fieldIdx++));
                rec.setLoggedDateTime((Date)record.get(fieldIdx++));
                rec.setLoggedLevel((String)record.get(fieldIdx++));
                rec.setProductName((String)record.get(fieldIdx++));
                rec.setLoggerName((String)record.get(fieldIdx++));
                rec.setNameValuePairs((String)record.get(fieldIdx++));
                rec.setMessageID((String)record.get(fieldIdx++));
                rec.setMessage((String)record.get(fieldIdx++));
                records.add(rec);
            }
        }
        return records;
    }
}

