/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.admin.rest.resources;

import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Produces;
import org.glassfish.admin.rest.resources.AbstractResource;
import org.glassfish.admin.rest.results.ActionReportResult;
import org.glassfish.admin.rest.results.OptionsResult;
import org.glassfish.admin.rest.utils.Util;
import org.glassfish.admin.rest.utils.xml.RestActionReporter;
import org.glassfish.api.ActionReport;
import org.glassfish.config.support.TranslatedConfigView;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.TransactionFailure;

public abstract class AbstractAttributeBagResource
extends AbstractResource {
    public static final LocalStringManagerImpl LOCAL_STRINGS = new LocalStringManagerImpl(AbstractAttributeBagResource.class);
    protected List<Dom> entity;
    protected Dom parent;
    protected String tagName;

    public abstract String getDescriptionName();

    public abstract String getPropertiesName();

    public abstract String getnodeElementName();

    public abstract List<Map<String, String>> getAllAttributes();

    @GET
    @Produces(value={"text/html", "application/json", "application/xml"})
    public ActionReportResult get() {
        RestActionReporter ar = new RestActionReporter();
        ar.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        ar.setActionDescription(this.getDescriptionName());
        List<Map<String, String>> attributes = this.getAllAttributes();
        Properties extraProperties = new Properties();
        extraProperties.put(this.getPropertiesName(), attributes);
        ar.setExtraProperties(extraProperties);
        return new ActionReportResult(this.tagName, ar, new OptionsResult(Util.getResourceName(this.uriInfo)));
    }

    @PUT
    @Consumes(value={"application/json", "application/xml", "application/x-www-form-urlencoded"})
    @Produces(value={"text/html", "application/json", "application/xml"})
    public ActionReportResult put(List<Map<String, String>> attributes) {
        RestActionReporter ar = new RestActionReporter();
        ar.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        ar.setActionDescription(this.getDescriptionName());
        try {
            this.setAttributes(attributes);
            List<Map<String, String>> currentAttributes = this.getAllAttributes();
            Properties extraProperties = new Properties();
            extraProperties.put(this.getPropertiesName(), currentAttributes);
            ar.setExtraProperties(extraProperties);
        }
        catch (TransactionFailure ex) {
            ar.setActionExitCode(ActionReport.ExitCode.FAILURE);
            ar.setMessage(ex.getMessage());
        }
        return new ActionReportResult(this.tagName, ar, new OptionsResult(Util.getResourceName(this.uriInfo)));
    }

    @POST
    @Consumes(value={"application/json", "application/xml", "application/x-www-form-urlencoded"})
    @Produces(value={"text/html", "application/json", "application/xml"})
    public ActionReportResult post(List<Map<String, String>> attributes) {
        List<Map<String, String>> currentAttributes = this.getAllAttributes();
        attributes.addAll(currentAttributes);
        return this.put(attributes);
    }

    @DELETE
    @Produces(value={"text/html", "application/json", "application/xml"})
    public ActionReportResult delete() {
        ArrayList<Map<String, String>> emptyList = new ArrayList<Map<String, String>>();
        return this.put(emptyList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttributes(List<Map<String, String>> attributes) throws TransactionFailure {
        TranslatedConfigView.doSubstitution.set(false);
        List<Map<String, String>> existingAttributes = this.getAllAttributes();
        ArrayList<Map<String, String>> attributesToAdd = new ArrayList<Map<String, String>>(attributes);
        Iterator iterator = attributesToAdd.iterator();
        while (iterator.hasNext()) {
            Map attributeToAdd = (Map)iterator.next();
            for (Map<String, String> existingAttribute : existingAttributes) {
                if (!this.attributesAreEqual(existingAttribute, attributeToAdd)) continue;
                iterator.remove();
            }
        }
        ArrayList<Map<String, String>> attributesToDelete = new ArrayList<Map<String, String>>(existingAttributes);
        iterator = attributesToDelete.iterator();
        while (iterator.hasNext()) {
            Map attributeToDelete = (Map)iterator.next();
            boolean specified = false;
            for (Map<String, String> specifiedAttribute : attributes) {
                if (!this.attributesAreEqual(specifiedAttribute, attributeToDelete)) continue;
                specified = true;
            }
            if (!specified) continue;
            iterator.remove();
        }
        this.excuteSetCommand(attributesToAdd, attributesToDelete);
        Dom dom = this.parent;
        synchronized (dom) {
            this.entity = this.parent.nodeElements(this.getnodeElementName());
        }
    }

    public abstract void excuteSetCommand(List<Map<String, String>> var1, List<Map<String, String>> var2) throws TransactionFailure;

    public abstract boolean attributesAreEqual(Map<String, String> var1, Map<String, String> var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParentAndTagName(Dom parent, String tagName) {
        this.parent = parent;
        this.tagName = tagName;
        if (parent != null) {
            Dom dom = parent;
            synchronized (dom) {
                this.entity = parent.nodeElements(this.getnodeElementName());
            }
        }
    }
}

