/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.monitoring.model;

import fish.payara.monitoring.model.ConstantDataset;
import fish.payara.monitoring.model.MinutesDataset;
import fish.payara.monitoring.model.SeriesDataset;
import fish.payara.monitoring.model.StableDataset;
import java.math.BigInteger;
import java.util.Arrays;

public final class PartialDataset
extends SeriesDataset {
    private final long time0;
    private final long[] data;
    private final int offset;
    private final int size;
    private final int observedValueChanges;
    private final long observedMax;
    private final long observedMin;
    private final BigInteger observedSum;
    private final int stableCount;
    private final long stableSince;
    private final MinutesDataset recentMinutes;

    PartialDataset(ConstantDataset predecessor, long time, long value, boolean aggregate) {
        super(predecessor);
        long lastTime = predecessor.lastTime();
        this.size = predecessor.size() + (lastTime == time ? 0 : 1);
        this.offset = 0;
        this.data = new long[predecessor.capacity() * 4];
        int i = 0;
        this.data[i++] = predecessor.getStableSince();
        this.data[i++] = predecessor.lastValue();
        if (predecessor.size() == 2 && lastTime < time) {
            this.data[i++] = lastTime;
            this.data[i++] = predecessor.lastValue();
        }
        this.data[i++] = time;
        this.data[i] = value;
        this.time0 = this.data[0];
        this.observedValueChanges = predecessor.getObservedValueChanges() + 1;
        this.observedMax = Math.max(value, predecessor.getObservedMax());
        this.observedMin = Math.min(value, predecessor.getObservedMin());
        this.observedSum = predecessor.getObservedSum().add(BigInteger.valueOf(value));
        this.stableCount = 1;
        this.stableSince = time;
        this.recentMinutes = PartialDataset.aggregate(predecessor, this, aggregate);
    }

    private PartialDataset(PartialDataset predecessor, int size, int offset, long time, long value, boolean aggregate) {
        super(predecessor);
        this.size = size;
        this.offset = offset;
        this.data = predecessor.data;
        this.time0 = predecessor.size == 0 ? time : predecessor.time0;
        this.observedMax = Math.max(value, predecessor.observedMax);
        this.observedMin = Math.min(value, predecessor.observedMin);
        this.observedSum = predecessor.observedSum.add(BigInteger.valueOf(value));
        if (predecessor.lastTime() == time) {
            long sum;
            this.data[2 * (offset + size - 1) + 1] = sum = predecessor.lastValue() + value;
            this.stableCount = 1;
            this.stableSince = time;
            this.observedValueChanges = predecessor.observedValueChanges + 1;
        } else {
            boolean stable = predecessor.size != 0 && value == predecessor.lastValue();
            this.observedValueChanges = predecessor.observedValueChanges + (stable ? 0 : 1);
            this.stableCount = stable ? predecessor.stableCount + 1 : 1;
            this.stableSince = stable ? predecessor.stableSince : time;
        }
        this.recentMinutes = PartialDataset.aggregate(predecessor, this, aggregate);
    }

    @Override
    public boolean isOutdated() {
        return this.time(0) != this.time0;
    }

    @Override
    public long getStableSince() {
        return this.stableSince;
    }

    @Override
    public int getStableCount() {
        return this.stableCount;
    }

    @Override
    public long getObservedMin() {
        return this.observedMin;
    }

    @Override
    public long getObservedMax() {
        return this.observedMax;
    }

    @Override
    public BigInteger getObservedSum() {
        return this.observedSum;
    }

    @Override
    public int getObservedValueChanges() {
        return this.observedValueChanges;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int capacity() {
        return this.data.length / 4;
    }

    public long value(int index) {
        return this.data[2 * (this.offset + index) + 1];
    }

    public long time(int index) {
        return this.data[2 * (this.offset + index)];
    }

    @Override
    public long lastValue() {
        return this.value(this.size - 1);
    }

    @Override
    public long firstTime() {
        return this.size == 0 ? -1L : this.time(0);
    }

    @Override
    public long lastTime() {
        return this.size == 0 ? -1L : this.time(this.size - 1);
    }

    @Override
    public long[] points() {
        return Arrays.copyOfRange(this.data, 2 * this.offset, 2 * (this.offset + this.size));
    }

    @Override
    public SeriesDataset add(long time, long value, boolean aggregate) {
        if (time == this.lastTime()) {
            return new PartialDataset(this, this.size, this.offset, time, value, aggregate);
        }
        int newOffset = this.offset;
        int newSize = this.size;
        if (this.size < this.capacity()) {
            this.data[2 * this.size] = time;
            this.data[2 * this.size + 1] = value;
            ++newSize;
        } else {
            if (this.offset == this.size) {
                if (this.isStable(value)) {
                    return new StableDataset(this, time, aggregate);
                }
                System.arraycopy(this.data, this.offset * 2, this.data, 0, this.size * 2);
                newOffset = 0;
            }
            this.data[2 * (newOffset + this.size)] = time;
            this.data[2 * (newOffset + this.size) + 1] = value;
            ++newOffset;
        }
        return new PartialDataset(this, newSize, newOffset, time, value, aggregate);
    }

    @Override
    public MinutesDataset getRecentMinutes() {
        return this.recentMinutes;
    }

    private boolean isStable(long value) {
        int i = this.data.length - 1;
        for (int j = 0; j < this.size; ++j) {
            if (this.data[i] != value) {
                return false;
            }
            i -= 2;
        }
        return true;
    }

    @Override
    public int estimatedBytesMemory() {
        return 116 + this.data.length * 8 + this.recentMinutes.estimatedBytesMemory();
    }

    @Override
    public boolean isStable() {
        return false;
    }
}

