/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.util.cluster;

import com.sun.enterprise.admin.report.DoNothingActionReporter;
import fish.payara.api.admin.config.NameGenerator;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.internal.api.Globals;

public final class PayaraServerNameGenerator {
    public static String validateInstanceNameUnique(String instanceName, AdminCommandContext context) {
        List<String> namesInUse = PayaraServerNameGenerator.getAllNamesInUse(context);
        return PayaraServerNameGenerator.validateInstanceNameUnique(instanceName, namesInUse);
    }

    public static String validateInstanceNameUnique(String instanceName, List<String> namesInUse) {
        if (!namesInUse.contains(instanceName)) {
            return instanceName;
        }
        return PayaraServerNameGenerator.validateInstanceNameUnique(instanceName + "-" + PayaraServerNameGenerator.generateNameNoHyphen(), namesInUse);
    }

    public static String generateNameNoHyphen() {
        int adjectivesIndex = ThreadLocalRandom.current().nextInt(0, NameGenerator.adjectives.length);
        int fishIndex = ThreadLocalRandom.current().nextInt(0, NameGenerator.fishes.length);
        return NameGenerator.adjectives[adjectivesIndex] + NameGenerator.fishes[fishIndex];
    }

    private static List<String> getAllNamesInUse(AdminCommandContext context) {
        ArrayList<String> namesInUse = new ArrayList<String>();
        CommandRunner commandRunner = (CommandRunner)Globals.getDefaultBaseServiceLocator().getService(CommandRunner.class, new Annotation[0]);
        namesInUse.addAll(PayaraServerNameGenerator.getInstanceNames((ActionReport)new DoNothingActionReporter(), context, commandRunner));
        namesInUse.addAll(PayaraServerNameGenerator.getNodeNames((ActionReport)new DoNothingActionReporter(), context, commandRunner));
        namesInUse.addAll(PayaraServerNameGenerator.getClusterNames((ActionReport)new DoNothingActionReporter(), context, commandRunner));
        namesInUse.addAll(PayaraServerNameGenerator.getDeploymentGroupNames((ActionReport)new DoNothingActionReporter(), context, commandRunner));
        namesInUse.addAll(PayaraServerNameGenerator.getConfigNames((ActionReport)new DoNothingActionReporter(), context, commandRunner));
        return namesInUse;
    }

    private static List<String> getInstanceNames(ActionReport report, AdminCommandContext context, CommandRunner commandRunner) {
        ArrayList<String> instanceNames = new ArrayList<String>();
        CommandRunner.CommandInvocation listInstancesCommand = commandRunner.getCommandInvocation("list-instances", report, context.getSubject());
        ParameterMap commandParameters = new ParameterMap();
        commandParameters.add((Object)"nostatus", (Object)"true");
        listInstancesCommand.parameters(commandParameters);
        listInstancesCommand.execute();
        Properties extraProperties = listInstancesCommand.report().getExtraProperties();
        if (extraProperties != null) {
            List instanceList = (List)extraProperties.get("instanceList");
            for (Map instanceMap : instanceList) {
                instanceNames.add((String)instanceMap.get("name"));
            }
        }
        return instanceNames;
    }

    private static List<String> getNodeNames(ActionReport report, AdminCommandContext context, CommandRunner commandRunner) {
        ArrayList<String> nodeNames = new ArrayList<String>();
        CommandRunner.CommandInvocation listNodesCommand = commandRunner.getCommandInvocation("list-nodes", report, context.getSubject());
        listNodesCommand.execute();
        Properties extraProperties = listNodesCommand.report().getExtraProperties();
        if (extraProperties != null) {
            nodeNames.addAll((List)extraProperties.get("nodeNames"));
        }
        return nodeNames;
    }

    private static List<String> getClusterNames(ActionReport report, AdminCommandContext context, CommandRunner commandRunner) {
        ArrayList<String> clusterNames = new ArrayList<String>();
        CommandRunner.CommandInvocation listClustersCommand = commandRunner.getCommandInvocation("list-clusters", report, context.getSubject());
        listClustersCommand.execute();
        Properties extraProperties = listClustersCommand.report().getExtraProperties();
        if (extraProperties != null) {
            clusterNames.addAll((Set)extraProperties.get("clusterNames"));
        }
        return clusterNames;
    }

    private static List<String> getDeploymentGroupNames(ActionReport report, AdminCommandContext context, CommandRunner commandRunner) {
        ArrayList<String> deploymentGroupNames = new ArrayList<String>();
        CommandRunner.CommandInvocation listDeploymentGroupsCommand = commandRunner.getCommandInvocation("list-deployment-groups", report, context.getSubject());
        listDeploymentGroupsCommand.execute();
        Properties extraProperties = listDeploymentGroupsCommand.report().getExtraProperties();
        if (extraProperties != null) {
            deploymentGroupNames.addAll((List)extraProperties.get("listOfDeploymentGroups"));
        }
        return deploymentGroupNames;
    }

    private static List<String> getConfigNames(ActionReport report, AdminCommandContext context, CommandRunner commandRunner) {
        ArrayList<String> configNames = new ArrayList<String>();
        CommandRunner.CommandInvocation listConfigsCommand = commandRunner.getCommandInvocation("list-configs", report, context.getSubject());
        listConfigsCommand.execute();
        Properties extraProperties = listConfigsCommand.report().getExtraProperties();
        if (extraProperties != null) {
            configNames.addAll((List)extraProperties.get("configNames"));
        }
        return configNames;
    }
}

