/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.concurrent.monitoring;

import fish.payara.concurrent.monitoring.ConcurrentMonitoringUtils;
import org.glassfish.concurrent.config.ManagedExecutorService;
import org.glassfish.concurrent.runtime.ConcurrentRuntime;
import org.glassfish.concurrent.runtime.deployer.ManagedExecutorServiceConfig;
import org.glassfish.enterprise.concurrent.ManagedExecutorServiceImpl;
import org.glassfish.external.probe.provider.StatsProviderManager;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.external.statistics.impl.CountStatisticImpl;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;

@AMXMetadata(type="managed-executor-service-mon", group="monitoring", isSingleton=false)
@ManagedObject
@Description(value="ManagedExecutorService Statistics")
public class ManagedExecutorServiceStatsProvider {
    private final String name;
    private boolean registered = false;
    private final ManagedExecutorServiceImpl managedExecutorServiceImpl;
    private CountStatisticImpl completedTaskCount = new CountStatisticImpl("CompletedTaskCount", "count", "Number of tasks completed");
    private CountStatisticImpl taskCount = new CountStatisticImpl("TaskCount", "count", "Total number of tasks ever scheduled");
    private CountStatisticImpl activeCount = new CountStatisticImpl("ActiveCount", "count", "The approximate number of active threads");
    private CountStatisticImpl largestPoolSize = new CountStatisticImpl("LargestPoolSize", "count", "The largest number of threads that have ever simultaneously been in the pool.");
    private CountStatisticImpl poolSize = new CountStatisticImpl("PoolSize", "count", "The current number of threads in the pool.");

    public ManagedExecutorServiceStatsProvider(ManagedExecutorService managedExecutorService) {
        ManagedExecutorServiceConfig managedExecutorServiceConfig = new ManagedExecutorServiceConfig(managedExecutorService);
        ConcurrentRuntime concurrentRuntime = ConcurrentRuntime.getRuntime();
        this.managedExecutorServiceImpl = concurrentRuntime.getManagedExecutorService(null, managedExecutorServiceConfig);
        this.name = this.managedExecutorServiceImpl.getName();
    }

    public void register() {
        String node = ConcurrentMonitoringUtils.registerSingleComponent(this.name, this);
        if (node != null) {
            this.registered = true;
        }
    }

    public void unregister() {
        if (this.registered) {
            this.registered = false;
            StatsProviderManager.unregister((Object)this);
        }
    }

    @ManagedAttribute(id="CompletedTaskCount")
    @Description(value="Number of tasks completed")
    public CountStatistic getCompletedTaskCount() {
        this.completedTaskCount.setCount(this.managedExecutorServiceImpl.getCompletedTaskCount());
        return this.completedTaskCount;
    }

    @ManagedAttribute(id="TaskCount")
    @Description(value="Total number of tasks ever scheduled")
    public CountStatistic getTaskCount() {
        this.taskCount.setCount(this.managedExecutorServiceImpl.getTaskCount());
        return this.taskCount;
    }

    @ManagedAttribute(id="ActiveCount")
    @Description(value="The approximate number of active threads")
    public CountStatistic getActiveCount() {
        this.activeCount.setCount((long)this.managedExecutorServiceImpl.getActiveCount());
        return this.activeCount;
    }

    @ManagedAttribute(id="LargestPoolSize")
    @Description(value="The largest number of threads that have ever simultaneously been in the pool")
    public CountStatistic getLargestPoolSize() {
        this.largestPoolSize.setCount((long)this.managedExecutorServiceImpl.getLargestPoolSize());
        return this.largestPoolSize;
    }

    @ManagedAttribute(id="PoolSize")
    @Description(value="The current number of threads in the pool")
    public CountStatistic getPoolSize() {
        this.poolSize.setCount((long)this.managedExecutorServiceImpl.getPoolSize());
        return this.poolSize;
    }
}

