/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.faulttolerance.admin;

import com.sun.enterprise.config.serverbeans.Config;
import fish.payara.microprofile.faulttolerance.FaultToleranceServiceConfiguration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.concurrent.ManagedExecutorService;
import javax.enterprise.concurrent.ManagedScheduledExecutorService;
import javax.inject.Inject;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="set-fault-tolerance-configuration")
@PerLookup
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG})
@RestEndpoints(value={@RestEndpoint(configBean=FaultToleranceServiceConfiguration.class, opType=RestEndpoint.OpType.POST, path="set-fault-tolerance-configuration", description="Sets the Fault Tolerance Configuration")})
public class SetFaultToleranceConfigurationCommand
implements AdminCommand {
    private static final Logger LOGGER = Logger.getLogger(SetFaultToleranceConfigurationCommand.class.getName());
    @Inject
    private Target targetUtil;
    @Param(optional=true, alias="managedexecutorservicename")
    private String managedExecutorServiceName;
    @Param(optional=true, alias="managedscheduledexecutorservicename")
    private String managedScheduledExecutorServiceName;
    @Param(optional=true, defaultValue="server-config")
    private String target;

    public void execute(AdminCommandContext acc) {
        ActionReport report = acc.getActionReport();
        Config targetConfig = this.targetUtil.getConfig(this.target);
        if (targetConfig == null) {
            report.setMessage("No such config name: " + this.targetUtil);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        FaultToleranceServiceConfiguration faultToleranceServiceConfiguration = (FaultToleranceServiceConfiguration)targetConfig.getExtensionByType(FaultToleranceServiceConfiguration.class);
        try {
            ConfigSupport.apply(configProxy -> {
                if (this.managedExecutorServiceName != null && SetFaultToleranceConfigurationCommand.validateManagedExecutor(this.managedExecutorServiceName, report)) {
                    configProxy.setManagedExecutorService(this.managedExecutorServiceName);
                }
                if (this.managedScheduledExecutorServiceName != null && SetFaultToleranceConfigurationCommand.validateManagedScheduledExecutor(this.managedScheduledExecutorServiceName, report)) {
                    configProxy.setManagedScheduledExecutorService(this.managedScheduledExecutorServiceName);
                }
                return null;
            }, (ConfigBeanProxy)faultToleranceServiceConfiguration);
        }
        catch (TransactionFailure ex) {
            report.failure(LOGGER, "Failed to update Fault Tolerance configuration", (Throwable)ex);
        }
    }

    private static boolean validateManagedScheduledExecutor(String name, ActionReport report) {
        return SetFaultToleranceConfigurationCommand.validateLookup(name, report, ManagedScheduledExecutorService.class);
    }

    private static boolean validateManagedExecutor(String name, ActionReport report) {
        return SetFaultToleranceConfigurationCommand.validateLookup(name, report, ManagedExecutorService.class);
    }

    private static boolean validateLookup(String name, ActionReport report, Class<?> type) {
        try {
            InitialContext ctx = new InitialContext();
            Object result = ctx.lookup(name);
            if (!type.isInstance(result)) {
                throw new IllegalArgumentException(String.format("Invalid object type for: %s. Was: %s Expected: %s.", name, result.getClass().getName(), type.getName()));
            }
        }
        catch (NamingException ex) {
            LOGGER.log(Level.WARNING, "Cannot find referenced object: " + name, ex);
            report.failure(LOGGER, "Cannot find referenced object: " + name);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return false;
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Invalid object: " + name, ex);
            report.failure(LOGGER, ex.getMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return false;
        }
        return true;
    }
}

