/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.util.stringifier;

import java.util.Iterator;
import org.glassfish.admin.amx.util.stringifier.IteratorStringifier;
import org.glassfish.admin.amx.util.stringifier.ObjectStringifier;
import org.glassfish.admin.amx.util.stringifier.SmartStringifier;
import org.glassfish.admin.amx.util.stringifier.Stringifier;

public abstract class IteratorStringifierBase
implements Stringifier {
    public static final IteratorStringifier DEFAULT = new IteratorStringifier(",");
    public final String mDelim;
    public final Stringifier mElementStringifier;

    public IteratorStringifierBase() {
        this(ObjectStringifier.DEFAULT);
    }

    public IteratorStringifierBase(String delim) {
        this(delim, new SmartStringifier(delim));
    }

    public IteratorStringifierBase(Stringifier elementStringifier) {
        this(",", elementStringifier);
    }

    public IteratorStringifierBase(String delim, Stringifier elementStringifier) {
        this.mDelim = delim;
        this.mElementStringifier = elementStringifier;
    }

    @Override
    public String stringify(Object o) {
        assert (o != null);
        Iterator iter = (Iterator)o;
        return this.stringify(iter, this.mDelim, this.mElementStringifier);
    }

    protected abstract void stringifyElement(Object var1, String var2, StringBuilder var3);

    public String stringify(Iterator iter, String delim, Stringifier stringifier) {
        assert (iter != null);
        StringBuilder buf = new StringBuilder();
        while (iter.hasNext()) {
            Object elem = iter.next();
            this.stringifyElement(elem, delim, buf);
            buf.append(delim);
        }
        int length = buf.length();
        if (length != 0) {
            buf.setLength(length - delim.length());
        }
        return buf.toString();
    }
}

