/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BrokerDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.ConsumerStateDAOImpl;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.StoreBeingTakenOverException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

class HADBConsumerStateDAOImpl
extends ConsumerStateDAOImpl {
    HADBConsumerStateDAOImpl() throws BrokerException {
    }

    @Override
    protected void deleteAll(Connection conn, String whereClause, String timestampColumn, int chunkSize) throws BrokerException {
        super.deleteAll(conn, whereClause, "CREATED_TS", 5000);
    }

    public void updateState(Connection conn, DestinationUID dstUID, SysMessageID sysMsgID, ConsumerUID conUID, int state) throws BrokerException {
        block14: {
            Exception myex;
            PreparedStatement pstmt;
            block13: {
                String msgID = sysMsgID.getUniqueName();
                boolean myConn = false;
                pstmt = null;
                myex = null;
                try {
                    BrokerDAO dao;
                    DBManager dbMgr = DBManager.getDBManager();
                    if (conn == null) {
                        conn = dbMgr.getConnection(true);
                        myConn = true;
                    }
                    if (Globals.getHAEnabled() && (dao = dbMgr.getDAOFactory().getBrokerDAO()).isBeingTakenOver(conn, dbMgr.getBrokerID())) {
                        StoreBeingTakenOverException be = new StoreBeingTakenOverException(this.br.getKString("B3223"));
                        throw be;
                    }
                    pstmt = DBManager.createPreparedStatement(conn, this.updateStateSQL);
                    pstmt.setInt(1, state);
                    pstmt.setString(2, msgID);
                    pstmt.setLong(3, conUID.longValue());
                    if (pstmt.executeUpdate() == 0) {
                        throw new BrokerException(this.br.getKString("B3014", conUID.toString(), msgID), 404);
                    }
                    if (!myConn) break block13;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", (Throwable)rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.updateStateSQL + "]", (SQLException)e) : e;
                        throw new BrokerException(this.br.getKString("B4015", conUID.toString(), sysMsgID.toString()), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(null, pstmt, conn, myex);
                        } else {
                            Util.close(null, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(null, pstmt, conn, myex);
                break block14;
            }
            Util.close(null, pstmt, null, myex);
        }
    }
}

