/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.remote;

import com.sun.enterprise.admin.remote.ManifestManager;
import com.sun.enterprise.admin.remote.PlainTextManager;
import com.sun.enterprise.admin.remote.RemoteException;
import com.sun.enterprise.admin.remote.RemoteFailureException;
import com.sun.enterprise.admin.remote.ResponseManager;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.io.FileUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Logger;

public class RemoteResponseManager
implements ResponseManager {
    private final int code;
    private final Logger logger;
    final InputStream responseStream;
    final String response;
    private static final int HTTP_SUCCESS_CODE = 200;
    private Map<String, String> mainAtts = Collections.emptyMap();
    private static final LocalStringsImpl STRINGS = new LocalStringsImpl(RemoteResponseManager.class);

    public RemoteResponseManager(InputStream in, int code, Logger logger) throws RemoteException, IOException {
        this.code = code;
        this.logger = logger;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        FileUtils.copy((InputStream)in, (OutputStream)baos, (long)0L);
        this.responseStream = new ByteArrayInputStream(baos.toByteArray());
        this.response = baos.toString();
        if (!StringUtils.ok((String)this.response)) {
            throw new RemoteFailureException(STRINGS.get("emptyResponse"));
        }
        logger.finer("------- RAW RESPONSE  ---------");
        logger.finer(this.response);
        logger.finer("------- RAW RESPONSE  ---------");
    }

    @Override
    public void process() throws RemoteException {
        this.checkCode();
        try {
            this.handleManifest();
        }
        catch (RemoteFailureException e) {
            throw e;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.handlePlainText();
        throw new RemoteFailureException(STRINGS.get("internal", new Object[]{this.response}));
    }

    public Map<String, String> getMainAtts() {
        return this.mainAtts;
    }

    private void checkCode() throws RemoteFailureException {
        if (this.code != 200) {
            throw new RemoteFailureException(STRINGS.get("badHttpCode", new Object[]{this.code}));
        }
    }

    private void handleManifest() throws RemoteException, IOException {
        ManifestManager mgr = new ManifestManager(this.responseStream, this.logger);
        this.mainAtts = mgr.getMainAtts();
        mgr.process();
    }

    private void handlePlainText() throws RemoteException {
        PlainTextManager mgr = new PlainTextManager(this.response);
        mgr.process();
    }
}

