/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.requesttracing.configuration;

import java.beans.PropertyVetoException;
import java.util.List;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Pattern;
import org.glassfish.api.admin.config.ConfigExtension;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.Configured;
import org.jvnet.hk2.config.Element;

@Configured
public interface RequestTracingServiceConfiguration
extends ConfigExtension {
    @Attribute(defaultValue="false", dataType=Boolean.class)
    public String getEnabled();

    public void enabled(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="1.0")
    @Pattern(regexp="0(\\.\\d+)?|1(\\.0)?", message="Must be a valid double between 0 and 1")
    public @Pattern(regexp="0(\\.\\d+)?|1(\\.0)?", message="Must be a valid double between 0 and 1") String getSampleRate();

    public void setSampleRate(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="false", dataType=Boolean.class)
    public String getAdaptiveSamplingEnabled();

    public void setAdaptiveSamplingEnabled(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="6", dataType=Integer.class)
    @Min(value=1L, message="Adaptive sampling target count must be greater than 0")
    @Max(value=0x7FFFFFFFL, message="Adaptive sampling target count must be less than 2147483647")
    public @Min(value=1L, message="Adaptive sampling target count must be greater than 0") @Max(value=0x7FFFFFFFL, message="Adaptive sampling target count must be less than 2147483647") String getAdaptiveSamplingTargetCount();

    public void setAdaptiveSamplingTargetCount(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="1", dataType=Integer.class)
    @Min(value=1L, message="Adaptive sampling time value must be greater than 0")
    @Max(value=0x7FFFFFFFL, message="Adaptive sampling time value must be less than 2147483647")
    public @Min(value=1L, message="Adaptive sampling time value must be greater than 0") @Max(value=0x7FFFFFFFL, message="Adaptive sampling time value must be less than 2147483647") String getAdaptiveSamplingTimeValue();

    public void setAdaptiveSamplingTimeValue(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="MINUTES")
    @Pattern(regexp="SECONDS|MINUTES|HOURS|DAYS", message="Invalid time unit. Value must be one of: SECONDS, MINUTES, HOURS, DAYS.")
    public @Pattern(regexp="SECONDS|MINUTES|HOURS|DAYS", message="Invalid time unit. Value must be one of: SECONDS, MINUTES, HOURS, DAYS.") String getAdaptiveSamplingTimeUnit();

    public void setAdaptiveSamplingTimeUnit(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="true", dataType=Boolean.class)
    public String getApplicationsOnlyEnabled();

    public void setApplicationsOnlyEnabled(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="30", dataType=Integer.class)
    @Min(value=0L, message="Threshold value must be at least 0")
    @Max(value=0x7FFFFFFFL, message="Threshold value must be less than 2147483647")
    public @Min(value=0L, message="Threshold value must be at least 0") @Max(value=0x7FFFFFFFL, message="Threshold value must be less than 2147483647") String getThresholdValue();

    public void setThresholdValue(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="SECONDS")
    @Pattern(regexp="NANOSECONDS|MICROSECONDS|MILLISECONDS|SECONDS|MINUTES|HOURS|DAYS", message="Invalid time unit. Value must be one of: NANOSECONDS, MICROSECONDS, MILLISECONDS, SECONDS, MINUTES, HOURS, DAYS.")
    public @Pattern(regexp="NANOSECONDS|MICROSECONDS|MILLISECONDS|SECONDS|MINUTES|HOURS|DAYS", message="Invalid time unit. Value must be one of: NANOSECONDS, MICROSECONDS, MILLISECONDS, SECONDS, MINUTES, HOURS, DAYS.") String getThresholdUnit();

    public void setThresholdUnit(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="true", dataType=Boolean.class)
    public String getSampleRateFirstEnabled();

    public void setSampleRateFirstEnabled(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="20", dataType=Integer.class)
    @Min(value=0L, message="Trace store size must be greater than or equal to 0")
    public @Min(value=0L, message="Trace store size must be greater than or equal to 0") String getTraceStoreSize();

    public void setTraceStoreSize(String var1) throws PropertyVetoException;

    @Attribute
    public String getTraceStoreTimeout();

    public void setTraceStoreTimeout(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="false", dataType=Boolean.class)
    public String getReservoirSamplingEnabled();

    public void setReservoirSamplingEnabled(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="false", dataType=Boolean.class)
    public String getHistoricTraceStoreEnabled();

    public void setHistoricTraceStoreEnabled(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="20", dataType=Integer.class)
    @Min(value=0L, message="Historic trace store size must be greater than or equal to 0")
    public @Min(value=0L, message="Historic trace store size must be greater than or equal to 0") String getHistoricTraceStoreSize();

    public void setHistoricTraceStoreSize(String var1) throws PropertyVetoException;

    @Attribute
    public String getHistoricTraceStoreTimeout();

    public void setHistoricTraceStoreTimeout(String var1) throws PropertyVetoException;

    @Element(value="notifier")
    public List<String> getNotifierList();
}

