/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.Arrays;
import sun.security.ssl.HandshakeContext;
import sun.security.ssl.Utilities;

final class RandomCookie {
    final byte[] randomBytes = new byte[32];
    private static final byte[] hrrRandomBytes = new byte[]{-49, 33, -83, 116, -27, -102, 97, 17, -66, 29, -116, 2, 30, 101, -72, -111, -62, -94, 17, 22, 122, -69, -116, 94, 7, -98, 9, -30, -56, -88, 51, -100};
    private static final byte[] t12Protection = new byte[]{68, 79, 87, 78, 71, 82, 68, 1};
    private static final byte[] t11Protection = new byte[]{68, 79, 87, 78, 71, 82, 68, 0};
    static final RandomCookie hrrRandom = new RandomCookie(hrrRandomBytes);

    RandomCookie(SecureRandom secureRandom) {
        secureRandom.nextBytes(this.randomBytes);
    }

    RandomCookie(HandshakeContext handshakeContext) {
        SecureRandom secureRandom = handshakeContext.sslContext.getSecureRandom();
        secureRandom.nextBytes(this.randomBytes);
        byte[] byArray = null;
        if (handshakeContext.maximumActiveProtocol.useTLS13PlusSpec()) {
            if (!handshakeContext.negotiatedProtocol.useTLS13PlusSpec()) {
                byArray = handshakeContext.negotiatedProtocol.useTLS12PlusSpec() ? t12Protection : t11Protection;
            }
        } else if (handshakeContext.maximumActiveProtocol.useTLS12PlusSpec() && !handshakeContext.negotiatedProtocol.useTLS12PlusSpec()) {
            byArray = t11Protection;
        }
        if (byArray != null) {
            System.arraycopy(byArray, 0, this.randomBytes, this.randomBytes.length - byArray.length, byArray.length);
        }
    }

    RandomCookie(ByteBuffer byteBuffer) throws IOException {
        byteBuffer.get(this.randomBytes);
    }

    private RandomCookie(byte[] byArray) {
        System.arraycopy(byArray, 0, this.randomBytes, 0, 32);
    }

    public String toString() {
        return "random_bytes = {" + Utilities.toHexString(this.randomBytes) + "}";
    }

    boolean isHelloRetryRequest() {
        return Arrays.equals(hrrRandomBytes, this.randomBytes);
    }

    boolean isVersionDowngrade(HandshakeContext handshakeContext) {
        if (handshakeContext.maximumActiveProtocol.useTLS13PlusSpec()) {
            if (!handshakeContext.negotiatedProtocol.useTLS13PlusSpec()) {
                return this.isT12Downgrade() || this.isT11Downgrade();
            }
        } else if (handshakeContext.maximumActiveProtocol.useTLS12PlusSpec() && !handshakeContext.negotiatedProtocol.useTLS12PlusSpec()) {
            return this.isT11Downgrade();
        }
        return false;
    }

    private boolean isT12Downgrade() {
        return Arrays.equals(Arrays.copyOfRange(this.randomBytes, 24, 32), Arrays.copyOfRange(t12Protection, 0, 8));
    }

    private boolean isT11Downgrade() {
        return Arrays.equals(Arrays.copyOfRange(this.randomBytes, 24, 32), Arrays.copyOfRange(t11Protection, 0, 8));
    }
}

