/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.admin.cluster;

import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.ResourceRef;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import fish.payara.enterprise.config.serverbeans.DGServerRef;
import fish.payara.enterprise.config.serverbeans.DeploymentGroup;
import fish.payara.enterprise.config.serverbeans.DeploymentGroups;
import java.util.Arrays;
import java.util.List;
import java.util.StringJoiner;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.FailurePolicy;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="add-instance-to-deployment-group")
@I18n(value="add.instance.to.deployment.group")
@PerLookup
@ExecuteOn(value={RuntimeType.ALL}, ifFailure=FailurePolicy.Ignore, ifOffline=FailurePolicy.Ignore, ifNeverStarted=FailurePolicy.Ignore)
@RestEndpoints(value={@RestEndpoint(configBean=DeploymentGroups.class, opType=RestEndpoint.OpType.POST, path="add-instance-to-deployment-group", description="Add Instance to a Deployment Group")})
public class AddInstanceToDeploymentGroupCommand
implements AdminCommand {
    @Param(name="instance")
    String instanceName;
    @Param(name="deploymentGroup")
    String deploymentGroupName;
    @Inject
    private Domain domain;
    @Inject
    ServerEnvironment env;
    @Inject
    CommandRunner commandRunner;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        DeploymentGroup deploymentGroup = this.domain.getDeploymentGroupNamed(this.deploymentGroupName);
        if (deploymentGroup == null && this.env.isDas()) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage("Deployment Group " + deploymentGroup + " does not exist");
            return;
        }
        List<String> instances = Arrays.asList(this.instanceName.split(","));
        for (String instance : instances) {
            ParameterMap parameters;
            CommandRunner.CommandInvocation inv;
            Server server = this.domain.getServerNamed(instance);
            if (server == null && this.env.isDas()) {
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setMessage("Instance " + instance + " does not exist");
                return;
            }
            try {
                ConfigSupport.apply(dg1 -> {
                    DGServerRef deploymentGroupServerRef = (DGServerRef)dg1.createChild(DGServerRef.class);
                    deploymentGroupServerRef.setRef(instance);
                    dg1.getDGServerRef().add(deploymentGroupServerRef);
                    return deploymentGroupServerRef;
                }, (ConfigBeanProxy)deploymentGroup);
            }
            catch (TransactionFailure e) {
                report.setMessage("Failed to add instance to deployment group");
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setFailureCause((Throwable)e);
            }
            for (ApplicationRef applicationRef : deploymentGroup.getApplicationRef()) {
                inv = this.commandRunner.getCommandInvocation("create-application-ref", report, context.getSubject());
                parameters = new ParameterMap();
                parameters.add((Object)"target", (Object)instance);
                parameters.add((Object)"name", (Object)applicationRef.getRef());
                String virtualServers = applicationRef.getVirtualServers();
                if (virtualServers == null || virtualServers.isEmpty()) {
                    virtualServers = this.getVirtualServers(server);
                }
                parameters.add((Object)"virtualservers", (Object)virtualServers);
                parameters.add((Object)"enabled", (Object)applicationRef.getEnabled());
                parameters.add((Object)"lbenabled", (Object)applicationRef.getLbEnabled());
                inv.parameters(parameters).execute();
            }
            for (ResourceRef resourceRef : deploymentGroup.getResourceRef()) {
                inv = this.commandRunner.getCommandInvocation("create-resource-ref", report, context.getSubject());
                parameters = new ParameterMap();
                parameters.add((Object)"target", (Object)instance);
                parameters.add((Object)"reference_name", (Object)resourceRef.getRef());
                parameters.add((Object)"enabled", (Object)resourceRef.getEnabled());
                inv.parameters(parameters).execute();
            }
        }
    }

    private String getVirtualServers(Server server) {
        List hosts;
        HttpService httpService;
        Config config = this.domain.getConfigs().getConfigByName(server.getConfigRef());
        StringJoiner virtualServers = new StringJoiner(",");
        if (config != null && (httpService = config.getHttpService()) != null && (hosts = httpService.getVirtualServer()) != null) {
            for (VirtualServer host : hosts) {
                if ("__asadmin".equals(host.getId())) continue;
                virtualServers.add(host.getId());
            }
        }
        return virtualServers.toString();
    }
}

