/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.jms.xml;

import com.sun.messaging.bridge.service.jms.JMSBridge;
import java.util.Properties;

public class DestinationElement {
    private Properties _attrs = null;
    private Properties _props = null;
    private String _type = null;

    public void setAttributes(Properties a) throws IllegalArgumentException {
        if (a != null) {
            String refname = a.getProperty("ref-name");
            if (refname.equals("imq.bridge.jms.dmq") || refname.equals("built-in-dmq") || refname.equals("AS_SOURCE")) {
                throw new IllegalArgumentException(JMSBridge.getJMSBridgeResources().getKString("BSJ4029", "ref-name=" + refname));
            }
            if (a.getProperty("lookup-name") == null) {
                String name = a.getProperty("name");
                if (name == null) {
                    Object[] params = new String[]{"lookup-name", "name", "destination"};
                    throw new IllegalArgumentException(JMSBridge.getJMSBridgeResources().getKString("BSJ4030", params));
                }
                if (name.equals("imq.bridge.jms.dmq")) {
                    throw new IllegalArgumentException(JMSBridge.getJMSBridgeResources().getKString("BSJ4029", "name=" + name));
                }
            }
        }
        this._attrs = a;
    }

    public void setProperties(Properties a) {
        this._props = a;
    }

    public Properties getAttributes() {
        return this._attrs;
    }

    public Properties getProperties() {
        return this._props;
    }

    public String getName() throws Exception {
        String name = this._attrs.getProperty("name");
        String lookup = this._attrs.getProperty("lookup-name");
        if (lookup != null) {
            throw new UnsupportedOperationException("Called when lookup-name is specified");
        }
        if (name == null) {
            throw new IllegalArgumentException(JMSBridge.getJMSBridgeResources().getKString("BSJ4031", "name", "destination"));
        }
        return name;
    }

    public String getLookupName() {
        return this._attrs.getProperty("lookup-name");
    }

    public String getRefName() {
        return this._attrs.getProperty("ref-name");
    }

    public boolean isQueue() throws Exception {
        if (this._type == null) {
            this._type = this._attrs.getProperty("type");
        }
        if (this.getLookupName() != null) {
            throw new UnsupportedOperationException("Called when lookup-name is specified");
        }
        if (this._type == null) {
            throw new IllegalArgumentException(JMSBridge.getJMSBridgeResources().getKString("BSJ4031", "type", "destination"));
        }
        this._type = this._type.trim().toLowerCase();
        return !this._type.equals("topic");
    }

    public String toString() {
        return "destination[" + this.getRefName() + "]";
    }
}

