/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.validation.internal;

import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.validation.Configuration;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.TraversableResolver;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.ValidationProviderResolver;
import javax.validation.Validator;
import javax.validation.ValidatorContext;
import javax.validation.ValidatorFactory;
import javax.validation.spi.ValidationProvider;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Providers;
import org.glassfish.jersey.internal.ServiceFinder;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.ClassBinding;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.internal.inject.SupplierClassBinding;
import org.glassfish.jersey.internal.util.PropertiesHelper;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.model.internal.RankedComparator;
import org.glassfish.jersey.server.internal.inject.ConfiguredValidator;
import org.glassfish.jersey.server.spi.ValidationInterceptor;
import org.glassfish.jersey.server.validation.ValidationConfig;
import org.glassfish.jersey.server.validation.internal.CompositeInjectingConstraintValidatorFactory;
import org.glassfish.jersey.server.validation.internal.DefaultConfiguredValidator;
import org.glassfish.jersey.server.validation.internal.InjectingConstraintValidatorFactory;
import org.glassfish.jersey.server.validation.internal.LocalizationMessages;
import org.glassfish.jersey.server.validation.internal.ValidateOnExecutionHandler;
import org.glassfish.jersey.server.validation.internal.ValidateOnExecutionTraversableResolver;
import org.glassfish.jersey.server.validation.internal.ValidationErrorMessageBodyWriter;
import org.glassfish.jersey.server.validation.internal.ValidationExceptionMapper;

public final class ValidationBinder
extends AbstractBinder {
    private static final Logger LOGGER = Logger.getLogger(ValidationBinder.class.getName());

    protected void configure() {
        ((SupplierClassBinding)this.bindFactory(DefaultConfigurationProvider.class, Singleton.class).to(Configuration.class)).in(Singleton.class);
        ((SupplierClassBinding)this.bindFactory(DefaultValidatorFactoryProvider.class, Singleton.class).to(ValidatorFactory.class)).in(Singleton.class);
        ((SupplierClassBinding)this.bindFactory(DefaultValidatorProvider.class, Singleton.class).to(Validator.class)).in(Singleton.class);
        this.bindFactory(ConfiguredValidatorProvider.class, Singleton.class).to(ConfiguredValidator.class);
        ((ClassBinding)this.bind(ValidationExceptionMapper.class).to(ExceptionMapper.class)).in(Singleton.class);
        ((ClassBinding)this.bind(ValidationErrorMessageBodyWriter.class).to(MessageBodyWriter.class)).in(Singleton.class);
    }

    private static class ConfiguredValidatorProvider
    implements Supplier<ConfiguredValidator> {
        @Inject
        private InjectionManager injectionManager;
        @Inject
        private Configuration validationConfig;
        @Inject
        private ValidatorFactory factory;
        @Context
        private javax.ws.rs.core.Configuration jaxRsConfig;
        @Context
        private Providers providers;
        @Context
        private ResourceContext resourceContext;
        private ConfiguredValidator defaultValidator;
        private final WeakHashMap<ContextResolver<ValidationConfig>, ConfiguredValidator> validatorCache = new WeakHashMap();

        private ConfiguredValidatorProvider() {
        }

        @Override
        public ConfiguredValidator get() {
            ContextResolver contextResolver = this.providers.getContextResolver(ValidationConfig.class, MediaType.WILDCARD_TYPE);
            if (contextResolver == null) {
                return this.getDefaultValidator();
            }
            if (!this.validatorCache.containsKey(contextResolver)) {
                ValidateOnExecutionHandler validateOnExecutionHandler = new ValidateOnExecutionHandler(this.validationConfig, !this.isValidateOnExecutableOverrideCheckDisabled());
                ValidatorContext context = this.getDefaultValidatorContext(validateOnExecutionHandler);
                ValidationConfig config = (ValidationConfig)contextResolver.getContext(ValidationConfig.class);
                if (config != null) {
                    if (config.getMessageInterpolator() != null) {
                        context.messageInterpolator(config.getMessageInterpolator());
                    }
                    if (config.getTraversableResolver() != null) {
                        context.traversableResolver((TraversableResolver)this.getTraversableResolver(config.getTraversableResolver(), validateOnExecutionHandler));
                    }
                    if (config.getConstraintValidatorFactory() != null) {
                        context.constraintValidatorFactory(config.getConstraintValidatorFactory());
                    }
                    if (config.getParameterNameProvider() != null) {
                        context.parameterNameProvider(config.getParameterNameProvider());
                    }
                }
                this.validatorCache.put((ContextResolver<ValidationConfig>)contextResolver, new DefaultConfiguredValidator(context.getValidator(), this.validationConfig, validateOnExecutionHandler, this.getValidationInterceptors()));
            }
            return this.validatorCache.get(contextResolver);
        }

        private Iterable<ValidationInterceptor> getValidationInterceptors() {
            Iterable validationInterceptorIterable = org.glassfish.jersey.internal.inject.Providers.getAllRankedProviders((InjectionManager)this.injectionManager, ValidationInterceptor.class);
            return org.glassfish.jersey.internal.inject.Providers.sortRankedProviders((RankedComparator)new RankedComparator(), (Iterable)validationInterceptorIterable);
        }

        private ConfiguredValidator getDefaultValidator() {
            if (this.defaultValidator == null) {
                ValidateOnExecutionHandler validateOnExecutionHandler = new ValidateOnExecutionHandler(this.validationConfig, !this.isValidateOnExecutableOverrideCheckDisabled());
                Validator validator = this.getDefaultValidatorContext(validateOnExecutionHandler).getValidator();
                this.defaultValidator = new DefaultConfiguredValidator(validator, this.validationConfig, validateOnExecutionHandler, this.getValidationInterceptors());
            }
            return this.defaultValidator;
        }

        private ValidatorContext getDefaultValidatorContext(ValidateOnExecutionHandler handler) {
            ValidatorContext context = this.factory.usingContext();
            if (AccessController.doPrivileged(ReflectionHelper.classForNamePA((String)"javax.enterprise.inject.spi.BeanManager")) != null) {
                context.constraintValidatorFactory((ConstraintValidatorFactory)this.resourceContext.getResource(CompositeInjectingConstraintValidatorFactory.class));
            } else {
                context.constraintValidatorFactory((ConstraintValidatorFactory)this.resourceContext.getResource(InjectingConstraintValidatorFactory.class));
            }
            context.traversableResolver((TraversableResolver)this.getTraversableResolver(this.factory.getTraversableResolver(), handler));
            return context;
        }

        private ValidateOnExecutionTraversableResolver getTraversableResolver(TraversableResolver delegate, ValidateOnExecutionHandler handler) {
            if (delegate == null) {
                delegate = this.validationConfig.getDefaultTraversableResolver();
            }
            boolean validationEnabled = this.validationConfig.getBootstrapConfiguration().isExecutableValidationEnabled();
            ValidateOnExecutionTraversableResolver traversableResolver = new ValidateOnExecutionTraversableResolver(delegate, handler, validationEnabled);
            return (ValidateOnExecutionTraversableResolver)this.resourceContext.initResource((Object)traversableResolver);
        }

        private boolean isValidateOnExecutableOverrideCheckDisabled() {
            return PropertiesHelper.isProperty((Object)this.jaxRsConfig.getProperty("jersey.config.beanValidation.disable.validateOnExecutableCheck.server"));
        }
    }

    private static class DefaultValidatorProvider
    implements Supplier<Validator> {
        @Inject
        private ValidatorFactory factory;

        private DefaultValidatorProvider() {
        }

        @Override
        public Validator get() {
            return this.factory.getValidator();
        }
    }

    private static class DefaultValidatorFactoryProvider
    implements Supplier<ValidatorFactory> {
        @Inject
        private Configuration config;

        private DefaultValidatorFactoryProvider() {
        }

        @Override
        public ValidatorFactory get() {
            return this.config.buildValidatorFactory();
        }
    }

    private static class DefaultConfigurationProvider
    implements Supplier<Configuration> {
        private final boolean inOsgi = ReflectionHelper.getOsgiRegistryInstance() != null;

        @Override
        public Configuration get() {
            try {
                if (!this.inOsgi) {
                    return Validation.byDefaultProvider().configure();
                }
                return Validation.byDefaultProvider().providerResolver(new ValidationProviderResolver(){

                    public List<ValidationProvider<?>> getValidationProviders() {
                        ArrayList validationProviders = new ArrayList();
                        for (ValidationProvider validationProvider : ServiceFinder.find(ValidationProvider.class)) {
                            validationProviders.add(validationProvider);
                        }
                        return validationProviders;
                    }
                }).configure();
            }
            catch (ValidationException e) {
                LOGGER.log(Level.FINE, LocalizationMessages.VALIDATION_EXCEPTION_PROVIDER(), e);
                throw e;
            }
        }
    }
}

