/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices.monitoring;

import com.oracle.webservices.api.databinding.JavaCallInfo;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.model.SOAPSEIModel;
import org.glassfish.webservices.monitoring.MonitorContext;

public class MonitorContextImpl
implements MonitorContext {
    private final JavaCallInfo callInfo;
    private final SOAPSEIModel seiModel;
    private final WSDLPort wsdlModel;
    private final WSEndpoint<?> ownerEndpoint;
    private final WebServiceEndpoint endpoint;

    public MonitorContextImpl(JavaCallInfo callInfo, SOAPSEIModel seiModel, WSDLPort wsdlModel, WSEndpoint<?> ownerEndpoint, WebServiceEndpoint endpoint) {
        this.callInfo = callInfo;
        this.seiModel = seiModel;
        this.wsdlModel = wsdlModel;
        this.ownerEndpoint = ownerEndpoint;
        this.endpoint = endpoint;
    }

    @Override
    public Class<?> getImplementationClass() {
        String className = this.endpoint.getEjbComponentImpl() != null ? this.endpoint.getEjbComponentImpl().getEjbClassName() : (this.endpoint.hasServletImplClass() ? this.endpoint.getServletImplClass() : this.endpoint.getWebComponentImpl().getWebComponentImplementation());
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public JavaCallInfo getCallInfo() {
        return this.callInfo;
    }

    @Override
    public SOAPSEIModel getSeiModel() {
        return this.seiModel;
    }

    @Override
    public WSDLPort getWsdlModel() {
        return this.wsdlModel;
    }

    @Override
    public WSEndpoint<?> getOwnerEndpoint() {
        return this.ownerEndpoint;
    }

    @Override
    public WebServiceEndpoint getEndpoint() {
        return this.endpoint;
    }
}

