/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node.runtime.common;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.ServiceRefPortInfo;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.MethodNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.XMLNode;
import com.sun.enterprise.deployment.runtime.common.MessageDescriptor;
import org.w3c.dom.Node;

public class MessageNode
extends DeploymentDescriptorNode<MessageDescriptor> {
    private static final String ALL_METHODS = "*";
    MessageDescriptor descriptor;

    public MessageNode() {
        this.registerElementHandler(new XMLElement("java-method"), MethodNode.class, "setMethodDescriptor");
    }

    @Override
    public MessageDescriptor getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = new MessageDescriptor();
            this.setMiscDescriptors();
        }
        return this.descriptor;
    }

    @Override
    public void setElementValue(XMLElement element, String value) {
        if ("operation-name".equals(element.getQName())) {
            this.descriptor.setOperationName(value);
        } else {
            super.setElementValue(element, value);
        }
    }

    @Override
    public Node writeDescriptor(Node parent, String nodeName, MessageDescriptor messageDesc) {
        MethodDescriptor methodDescriptor;
        Node messageNode = super.writeDescriptor(parent, nodeName, messageDesc);
        if (messageDesc.getOperationName() == null && messageDesc.getMethodDescriptor() == null) {
            MethodDescriptor allMethodDesc = new MethodDescriptor();
            allMethodDesc.setName(ALL_METHODS);
            messageDesc.setMethodDescriptor(allMethodDesc);
        }
        if ((methodDescriptor = messageDesc.getMethodDescriptor()) != null) {
            new MethodNode().writeJavaMethodDescriptor(messageNode, "java-method", methodDescriptor);
        }
        MessageNode.appendTextChild(messageNode, "operation-name", messageDesc.getOperationName());
        return messageNode;
    }

    private void setMiscDescriptors() {
        XMLNode parentNode = this.getParentNode().getParentNode().getParentNode();
        Object parentDesc = parentNode.getDescriptor();
        if (parentDesc instanceof ServiceRefPortInfo) {
            this.descriptor.setServiceRefPortInfo((ServiceRefPortInfo)((Object)parentDesc));
        } else if (parentDesc instanceof WebServiceEndpoint) {
            this.descriptor.setWebServiceEndpoint((WebServiceEndpoint)parentDesc);
        }
        BundleDescriptor bundleDescriptor = null;
        parentNode = parentNode.getParentNode().getParentNode();
        if (parentNode.getDescriptor() instanceof WebBundleDescriptor) {
            bundleDescriptor = (WebBundleDescriptor)parentNode.getDescriptor();
        } else if (parentNode.getDescriptor() instanceof BundleDescriptor) {
            bundleDescriptor = (BundleDescriptor)parentNode.getDescriptor();
        } else if (parentNode.getDescriptor() instanceof EjbDescriptor) {
            EjbDescriptor ejbDesc = (EjbDescriptor)parentNode.getDescriptor();
            bundleDescriptor = ejbDesc.getEjbBundleDescriptor();
        } else if ((parentNode = parentNode.getParentNode()).getDescriptor() instanceof EjbDescriptor) {
            EjbDescriptor ejbDesc = (EjbDescriptor)parentNode.getDescriptor();
            bundleDescriptor = ejbDesc.getEjbBundleDescriptor();
        }
        this.descriptor.setBundleDescriptor(bundleDescriptor);
    }
}

