/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.realm.file;

import com.sun.enterprise.config.serverbeans.AuthRealm;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.security.BaseRealm;
import com.sun.enterprise.security.auth.realm.BadRealmException;
import com.sun.enterprise.security.auth.realm.NoSuchRealmException;
import com.sun.enterprise.security.auth.realm.NoSuchUserException;
import com.sun.enterprise.security.auth.realm.User;
import com.sun.enterprise.security.auth.realm.file.FileRealmUser;
import com.sun.enterprise.security.common.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.glassfish.internal.api.RelativePathResolver;
import org.glassfish.security.common.FileRealmStorageManager;
import org.jvnet.hk2.annotations.Service;

@Service
public final class FileRealm
extends BaseRealm {
    public static final String AUTH_TYPE = "filepassword";
    public static final String PARAM_KEYFILE = "file";
    private FileRealmStorageManager fileRealmStorageManager;

    @Override
    public String getAuthType() {
        return AUTH_TYPE;
    }

    public FileRealm(String keyfile) throws BadRealmException, NoSuchRealmException {
        Properties properties = new Properties();
        properties.setProperty(PARAM_KEYFILE, keyfile);
        properties.setProperty("jaas-context", "ignore");
        this.init(properties);
    }

    public FileRealm() {
    }

    @Override
    protected void init(Properties props) throws BadRealmException, NoSuchRealmException {
        super.init(props);
        String file = props.getProperty(PARAM_KEYFILE);
        if (file == null) {
            throw new BadRealmException(sm.getString("filerealm.nofile"));
        }
        if (file.contains("$")) {
            file = RelativePathResolver.resolvePath((String)file);
        }
        this.setProperty(PARAM_KEYFILE, file);
        String jaasCtx = props.getProperty("jaas-context");
        if (jaasCtx == null) {
            throw new BadRealmException(sm.getString("filerealm.nomodule"));
        }
        this.setProperty("jaas-context", jaasCtx);
        _logger.log(Level.FINE, "FileRealm : file={0}", file);
        _logger.log(Level.FINE, "FileRealm : jaas-context={0}", jaasCtx);
        try {
            if (Util.isEmbeddedServer()) {
                file = Util.writeConfigFileToTempDir(file).getAbsolutePath();
            }
            this.fileRealmStorageManager = new FileRealmStorageManager(file);
        }
        catch (IOException ioe) {
            throw new BadRealmException(sm.getString("filerealm.noaccess", (Object)ioe.toString()));
        }
    }

    public String[] authenticate(String user, char[] password) {
        String[] groups = this.fileRealmStorageManager.authenticate(user, password);
        if (groups != null) {
            groups = this.addAssignGroups(groups);
        }
        return groups;
    }

    public static List<String> getRealmFileNames(Config config) {
        ArrayList<String> files = new ArrayList<String>();
        SecurityService securityService = config.getSecurityService();
        for (AuthRealm authRealm : securityService.getAuthRealm()) {
            String file;
            String fileRealmClassName = authRealm.getClassname();
            if (fileRealmClassName == null || !fileRealmClassName.equals(FileRealm.class.getName()) || (file = authRealm.getPropertyValue(PARAM_KEYFILE)) == null) continue;
            if (file.contains("$")) {
                file = RelativePathResolver.resolvePath((String)file);
            }
            files.add(file);
        }
        return files;
    }

    @Override
    public Enumeration<String> getUserNames() throws BadRealmException {
        return Collections.enumeration(this.fileRealmStorageManager.getUserNames());
    }

    @Override
    public User getUser(String name) throws NoSuchUserException {
        FileRealmStorageManager.User user = this.fileRealmStorageManager.getUser(name);
        if (user == null) {
            throw new NoSuchUserException(sm.getString("filerealm.nouser", (Object)name));
        }
        return new FileRealmUser(user, null);
    }

    @Override
    public Enumeration<String> getGroupNames() throws BadRealmException {
        return Collections.enumeration(this.fileRealmStorageManager.getGroupNames());
    }

    @Override
    public Enumeration<String> getGroupNames(String username) throws NoSuchUserException {
        String[] groups = this.fileRealmStorageManager.getGroupNames(username);
        if (groups == null) {
            groups = new String[]{};
        }
        return Collections.enumeration(Arrays.asList(this.addAssignGroups(groups)));
    }

    @Override
    public void refresh() throws BadRealmException {
        _logger.fine("Reloading file realm data.");
        try {
            FileRealm newFileRealm = new FileRealm(this.getProperty(PARAM_KEYFILE));
            newFileRealm.init(this.getProperties());
            FileRealm.updateInstance(newFileRealm, this.getName());
        }
        catch (Exception e) {
            throw new BadRealmException(e.toString());
        }
    }

    @Override
    public void refresh(String configName) throws BadRealmException {
        _logger.fine("Reloading file realm data.");
        try {
            FileRealm newFileRealm = new FileRealm(this.getProperty(PARAM_KEYFILE));
            newFileRealm.init(this.getProperties());
            FileRealm.updateInstance(configName, newFileRealm, this.getName());
        }
        catch (Exception e) {
            throw new BadRealmException(e.toString());
        }
    }

    @Override
    public void addUser(String name, char[] password, String[] groupList) {
        this.fileRealmStorageManager.addUser(name, password, groupList);
    }

    @Override
    public void removeUser(String name) {
        this.fileRealmStorageManager.removeUser(name);
    }

    @Override
    public void updateUser(String name, String newName, char[] password, String[] groups) {
        this.fileRealmStorageManager.updateUser(name, newName, password, groups);
    }

    @Override
    public void persist() throws BadRealmException {
        try {
            this.fileRealmStorageManager.persist();
        }
        catch (IOException ex) {
            throw new BadRealmException(ex);
        }
    }

    public boolean hasAuthenticatableUser() {
        return this.fileRealmStorageManager.hasAuthenticatableUser();
    }

    @Override
    public boolean supportsUserManagement() {
        return true;
    }
}

