/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.login.common;

import java.security.cert.X509Certificate;
import java.util.Arrays;

public class X509CertificateCredential {
    private final X509Certificate[] certChain;
    private final String realm;
    private final String alias;

    public X509CertificateCredential(X509Certificate[] certChain, String alias, String realm) {
        this.certChain = certChain;
        this.alias = alias;
        this.realm = realm;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getRealm() {
        return this.realm;
    }

    public X509Certificate[] getX509CertificateChain() {
        return this.certChain;
    }

    public boolean equals(Object o) {
        X509CertificateCredential pc;
        if (o instanceof X509CertificateCredential && (pc = (X509CertificateCredential)o).getRealm().equals(this.realm) && pc.getAlias().equals(this.alias)) {
            X509Certificate[] certs = pc.getX509CertificateChain();
            for (int i = 0; i < certs.length; ++i) {
                if (certs[i].equals(this.certChain[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.certChain) + this.realm.hashCode() + (this.alias != null ? this.alias.hashCode() : 0);
    }

    public String toString() {
        String s = "Realm=" + this.realm;
        s = s + " alias=" + this.alias;
        StringBuilder certChainStr = new StringBuilder("");
        for (int i = 0; i < this.certChain.length; ++i) {
            certChainStr.append(this.certChain[i].toString());
            certChainStr.append("\n");
        }
        s = s + " X509Certificate=" + certChainStr.toString();
        return s;
    }
}

