/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth;

import com.sun.enterprise.security.SecurityLoggerInfo;
import com.sun.enterprise.security.auth.login.LoginContextDriver;
import com.sun.enterprise.security.auth.login.common.LoginException;
import com.sun.enterprise.security.auth.login.common.PasswordCredential;
import com.sun.enterprise.security.auth.realm.Realm;
import com.sun.enterprise.security.auth.realm.certificate.CertificateRealm;
import com.sun.enterprise.security.auth.realm.certificate.OID;
import com.sun.enterprise.security.common.AppservAccessController;
import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.x500.X500Principal;
import org.glassfish.security.common.Group;

public class JaspicToJaasBridge {
    private static final Logger LOGGER = SecurityLoggerInfo.getLogger();

    public static Subject validateUsernamePasswordByJaas(Subject subject, String username, char[] password, String realm) throws LoginException {
        String validRealm = LoginContextDriver.getValidRealm(realm);
        Subject validSubject = LoginContextDriver.getValidSubject(subject);
        PasswordCredential passwordCredential = new PasswordCredential(username, password, validRealm);
        AppservAccessController.privileged(() -> validSubject.getPrivateCredentials().add(passwordCredential));
        String jaasCtx = LoginContextDriver.getJaasContext(validRealm);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "JASPIC login user [{0}] into realm: {1} using JAAS module: {2}", new Object[]{username, validRealm, jaasCtx});
        }
        LoginContextDriver.validateJaasLogin(username, jaasCtx, validRealm, validSubject);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "JASPIC Password login succeeded for : {0}", username);
        }
        return subject;
    }

    public static Subject jaasX500Login(Subject subject, X500Principal x500Principal) throws LoginException {
        Subject validSubject = LoginContextDriver.getValidSubject(subject);
        String callerPrincipalName = "";
        try {
            callerPrincipalName = x500Principal.getName("RFC2253", OID.getOIDMap());
            AppservAccessController.privileged(() -> validSubject.getPublicCredentials().add(x500Principal));
            CertificateRealm certRealm = (CertificateRealm)Realm.getInstance("certificate");
            String jaasCtx = certRealm.getJAASContext();
            if (jaasCtx != null) {
                LoginContext loginContext = new LoginContext(jaasCtx, validSubject, LoginContextDriver.dummyCallback);
                loginContext.login();
            }
            certRealm.authenticate(validSubject, x500Principal);
        }
        catch (Exception ex) {
            LOGGER.log(Level.INFO, "NCLS-SECURITY-05046", callerPrincipalName);
            LoginContextDriver.auditAuthenticate(callerPrincipalName, "certificate", false);
            if (ex instanceof LoginException) {
                throw (LoginException)ex;
            }
            throw (LoginException)new LoginException(ex.toString()).initCause(ex);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "JASPIC certificate login succeeded for: {0}", callerPrincipalName);
        }
        LoginContextDriver.auditAuthenticate(callerPrincipalName, "certificate", true);
        return subject;
    }

    public static Subject addRealmGroupsToSubject(Subject subject, String callerPrincipalName, String realmName) throws LoginException {
        block3: {
            Subject validSubject = LoginContextDriver.getValidSubject(subject);
            try {
                Enumeration<String> groupsEnumeration = LoginContextDriver.getRealmInstance(realmName).getGroupNames(callerPrincipalName);
                if (groupsEnumeration != null) {
                    AppservAccessController.privileged(() -> Collections.list(groupsEnumeration).stream().forEach(groupName -> validSubject.getPrincipals().add((Principal)new Group(groupName))));
                }
            }
            catch (Exception ex) {
                if (!LOGGER.isLoggable(Level.FINE)) break block3;
                LOGGER.log(Level.FINE, "Exception when trying to populate groups for CallerPrincipal " + callerPrincipalName, ex);
            }
        }
        return subject;
    }
}

