/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security;

import com.sun.enterprise.config.serverbeans.JaccProvider;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.security.SecurityLoggerInfo;
import com.sun.enterprise.util.i18n.StringManager;
import java.security.Policy;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.glassfish.hk2.api.IterableProvider;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.types.Property;

@Service
@Singleton
public class PolicyLoader {
    private static final Logger LOGGER = SecurityLoggerInfo.getLogger();
    private static final StringManager STRING_MANAGER = StringManager.getManager(PolicyLoader.class);
    private static final String POLICY_PROVIDER_14 = "javax.security.jacc.policy.provider";
    private static final String POLICY_PROVIDER_13 = "javax.security.jacc.auth.policy.provider";
    private static final String POLICY_CONF_FACTORY = "javax.security.jacc.PolicyConfigurationFactory.provider";
    private static final String POLICY_PROP_PREFIX = "com.sun.enterprise.jaccprovider.property.";
    @Inject
    @Named(value="default-instance-name")
    private SecurityService securityService;
    @Inject
    private IterableProvider<JaccProvider> jaccProviders;
    private boolean isPolicyInstalled;

    public void loadPolicy() {
        if (this.isPolicyInstalled) {
            LOGGER.fine("Policy already installed. Will not re-install.");
            return;
        }
        JaccProvider jaccProvider = this.getConfiguredJaccProvider();
        this.setPolicyConfigurationFactory(jaccProvider);
        boolean j2ee13 = false;
        String policyClassName = this.getConfiguredPolicyClassName(jaccProvider);
        if (policyClassName == null && (policyClassName = System.getProperty(POLICY_PROVIDER_13)) != null) {
            j2ee13 = true;
            LOGGER.log(Level.WARNING, "NCLS-SECURITY-01149", new String[]{POLICY_PROVIDER_13, policyClassName});
        }
        if (policyClassName != null) {
            this.installPolicyFromClassName(policyClassName, j2ee13);
        } else {
            LOGGER.warning("NCLS-SECURITY-01145");
        }
    }

    private String getConfiguredPolicyClassName(JaccProvider jaccProvider) {
        String policyClassName = System.getProperty(POLICY_PROVIDER_14);
        if (policyClassName != null) {
            LOGGER.log(Level.INFO, "NCLS-SECURITY-01140", new String[]{POLICY_PROVIDER_14, policyClassName});
        } else if (jaccProvider != null) {
            policyClassName = jaccProvider.getPolicyProvider();
        }
        return policyClassName;
    }

    private JaccProvider getConfiguredJaccProvider() {
        JaccProvider jaccProvider = null;
        try {
            String name = this.securityService.getJacc();
            jaccProvider = this.getJaccProviderByName(name);
            if (jaccProvider == null) {
                LOGGER.log(Level.WARNING, "NCLS-SECURITY-01141", name);
            }
        }
        catch (Exception e) {
            LOGGER.warning("NCLS-SECURITY-01142");
            jaccProvider = null;
        }
        return jaccProvider;
    }

    private JaccProvider getJaccProviderByName(String name) {
        if (this.jaccProviders == null || name == null) {
            return null;
        }
        for (JaccProvider jaccProvider : this.jaccProviders) {
            if (!jaccProvider.getName().equals(name)) continue;
            return jaccProvider;
        }
        return null;
    }

    private void setPolicyConfigurationFactory(JaccProvider jaccProvider) {
        if (jaccProvider == null) {
            return;
        }
        String prop = System.getProperty(POLICY_CONF_FACTORY);
        if (prop != null) {
            LOGGER.log(Level.WARNING, "NCLS-SECURITY-01146", new String[]{POLICY_CONF_FACTORY, prop});
        } else {
            String factory = jaccProvider.getPolicyConfigurationFactoryProvider();
            if (factory == null) {
                LOGGER.log(Level.WARNING, "NCLS-SECURITY-01147");
            } else {
                System.setProperty(POLICY_CONF_FACTORY, factory);
            }
        }
        for (Property jaccProperty : jaccProvider.getProperty()) {
            String name = POLICY_PROP_PREFIX + jaccProperty.getName();
            String value = jaccProperty.getValue();
            LOGGER.log(Level.FINEST, () -> "PolicyLoader set [" + name + "] to [" + value + "]");
            System.setProperty(name, value);
        }
    }

    private void installPolicyFromClassName(String policyClassName, boolean j2ee13) {
        try {
            LOGGER.log(Level.INFO, "NCLS-SECURITY-01143", policyClassName);
            Object policyInstance = this.loadClass(policyClassName);
            this.installPolicy14(policyInstance);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NCLS-SECURITY-01144", e.getLocalizedMessage());
            throw new RuntimeException(e);
        }
        LOGGER.log(Level.FINE, () -> "Policy set to: " + policyClassName);
        this.isPolicyInstalled = true;
    }

    private void installPolicy14(Object policyInstance) {
        if (!(policyInstance instanceof Policy)) {
            throw new RuntimeException(STRING_MANAGER.getString("enterprise.security.plcyload.not14"));
        }
        Policy policy = (Policy)policyInstance;
        Policy.setPolicy(policy);
        if (System.getSecurityManager() == null) {
            policy.refresh();
        }
    }

    private Object loadClass(String policyClassName) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        return Thread.currentThread().getContextClassLoader().loadClass(policyClassName).newInstance();
    }
}

