/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.ha.hazelcast.store;

import fish.payara.ha.hazelcast.store.HazelcastBackingStoreFactory;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.ha.store.api.BackingStore;
import org.glassfish.ha.store.api.BackingStoreConfiguration;
import org.glassfish.ha.store.api.BackingStoreException;
import org.glassfish.ha.store.api.BackingStoreFactory;
import org.glassfish.ha.store.api.BackingStoreTransaction;
import org.glassfish.ha.store.spi.BackingStoreFactoryRegistry;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.runlevel.RunLevel;
import org.jvnet.hk2.annotations.Service;

@Service(name="hazelcast")
@RunLevel(value=10)
public class HazelcastBackingStoreFactoryProxy
implements PostConstruct,
BackingStoreFactory {
    @Inject
    ServiceLocator habitat;

    @Override
    public <K extends Serializable, V extends Serializable> BackingStore<K, V> createBackingStore(BackingStoreConfiguration<K, V> bsc) throws BackingStoreException {
        try {
            BackingStoreFactory storeFactory = (BackingStoreFactory)this.habitat.getService(BackingStoreFactory.class, "hazelcast-factory", new Annotation[0]);
            return storeFactory.createBackingStore(bsc);
        }
        catch (Exception ex) {
            Logger.getLogger(HazelcastBackingStoreFactoryProxy.class.getName()).log(Level.WARNING, "Exception while creating hazelcast cache", ex);
            throw new BackingStoreException("Exception while creating hazelcast cache", ex);
        }
    }

    @Override
    public BackingStoreTransaction createBackingStoreTransaction() {
        try {
            BackingStoreFactory storeFactory = (BackingStoreFactory)this.habitat.getService(BackingStoreFactory.class, "hazelcast-factory", new Annotation[0]);
            return storeFactory.createBackingStoreTransaction();
        }
        catch (Exception ex) {
            throw new RuntimeException("Exception while creating hazelcast transaction", ex);
        }
    }

    public void postConstruct() {
        BackingStoreFactoryRegistry.register("hazelcast", this);
        Logger.getLogger(HazelcastBackingStoreFactory.class.getName()).log(Level.FINE, "Registered Hazelcast BackingStoreFactory with persistence-type = hazelcast");
    }
}

