/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.healthcheck.stuck;

import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import org.glassfish.hk2.runlevel.RunLevel;
import org.jvnet.hk2.annotations.Service;

@Service(name="stuck-threads-store")
@RunLevel(value=10)
public class StuckThreadsStore {
    private ConcurrentHashMap<Long, Long> threads = new ConcurrentHashMap();
    private Logger logger;

    @PostConstruct
    public void postConstruct() {
        this.logger = Logger.getLogger("fish.payara.nucleus.healthcheck");
    }

    public void registerThread(Long threadid) {
        this.threads.put(threadid, System.currentTimeMillis());
    }

    public void deregisterThread(long threadid) {
        if (this.threads.remove(threadid) == null) {
            this.logger.log(Level.FINE, "Tried to deregister non-existent thread {0}", threadid);
        }
    }

    public ConcurrentHashMap<Long, Long> getThreads() {
        return this.threads;
    }
}

