/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.utility.generator.io;

import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

class FormattedWriter {
    private static final String lineSeparator = System.getProperty("line.separator");
    private static final String indent = "    ";
    private StringBuilder _buffer;
    private int _initialIndents = 0;

    FormattedWriter() {
    }

    private StringBuilder getBuffer() {
        if (this._buffer == null) {
            this._buffer = new StringBuilder();
        }
        return this._buffer;
    }

    public String toString() {
        return this.getBuffer().toString();
    }

    void writeComments(String[] comments) {
        int n = comments != null ? comments.length : 0;
        for (int i = 0; i < n; ++i) {
            String s = comments[i];
            this.writeln("// " + (s != null ? s : ""));
        }
    }

    private void _write(int indents, String s) {
        StringBuilder buffer = this.getBuffer();
        if (!s.equals(lineSeparator)) {
            for (int i = 0; i < indents; ++i) {
                buffer.append(indent);
            }
        }
        buffer.append(s);
    }

    void write(int indents, String s) {
        this._write(indents + this._initialIndents, s);
    }

    void write(String s) {
        this._write(0, s);
    }

    void writeln(int indents, String s) {
        if (this._initialIndents > 0) {
            this._write(this._initialIndents, "");
        }
        this._write(indents, s + lineSeparator);
    }

    void writeln(String s) {
        this.writeln(0, s);
    }

    void writeln() {
        this.writeln(0, "");
    }

    void writeList(int indents, List list, boolean addSeparator) {
        if (list != null && list.size() > 0) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                this.indent(indents, iterator.next().toString());
                if (!addSeparator) continue;
                this.writeln();
            }
            if (!addSeparator) {
                this.writeln();
            }
        }
    }

    void writeList(int indents, List list) {
        this.writeList(indents, list, false);
    }

    void writeList(List list) {
        this.writeList(0, list);
    }

    private void indent(int indents, String s) {
        if (s.indexOf(lineSeparator) != -1) {
            StringTokenizer tokenizer = new StringTokenizer(s, lineSeparator, true);
            while (tokenizer.hasMoreTokens()) {
                this.write(indents, tokenizer.nextToken());
            }
        } else {
            this.write(indents, s);
        }
    }
}

