/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.launcher;

import com.sun.enterprise.server.logging.ODLLogFormatter;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.io.IOException;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.logging.annotation.LogMessageInfo;
import org.glassfish.logging.annotation.LogMessagesResourceBundle;
import org.glassfish.logging.annotation.LoggerInfo;

public class GFLauncherLogger {
    @LogMessagesResourceBundle
    public static final String SHARED_LOGMESSAGE_RESOURCE = "com.sun.enterprise.admin.launcher.LogMessages";
    @LoggerInfo(subsystem="Launcher", description="Launcher Logger", publish=true)
    public static final String LOGGER_NAME = "javax.enterprise.launcher";
    private static final Logger LOGGER;
    private static final LocalStringsImpl STRINGS;
    private static FileHandler logfileHandler;
    @LogMessageInfo(message="Single and double quote characters are not allowed in the CLASSPATH environmental variable.  They were stripped out for you.\nBefore: {0}\nAfter: {1}", comment="CLASSPATH is illegal.", cause="see message", action="see message", level="SEVERE")
    public static final String NO_QUOTES_ALLOWED = "NCLS-GFLAUNCHER-00001";
    @LogMessageInfo(message="Error Launching: {0}", comment="Launcher Error", cause="see message", action="fix the CLASSPATH", level="SEVERE")
    public static final String LAUNCH_FAILURE = "NCLS-GFLAUNCHER-00002";
    @LogMessageInfo(message="Could not locate the flashlight agent here: {0}", comment="catastrophic error", cause="see message", action="Find the agent file.", level="SEVERE")
    public static final String NO_FLASHLIGHT_AGENT = "NCLS-GFLAUNCHER-00003";
    @LogMessageInfo(message="Will copy glassfish/lib/templates/server.policy file to domain before upgrading.", comment="Upgrade Information", level="INFO")
    public static final String COPY_SERVER_POLICY = "NCLS-GFLAUNCHER-00004";
    @LogMessageInfo(message="JVM invocation command line:{0}", comment="Routine Information", cause="NA", action="NA", level="INFO")
    public static final String COMMAND_LINE = "NCLS-GFLAUNCHER-00005";
    @LogMessageInfo(message="Using Payara default value \"{1}\" for JVM option: {0}", comment="JVM Info", cause="JVM option not present in domain.xml", action="Override the Payara default by adding the JVM option to your config", level="FINE")
    public static final String DEFAULT_JVM_OPTION = "PAYARA-GFLAUNCHER-00001";

    private GFLauncherLogger() {
    }

    public static void warning(String msg, Object ... objs) {
        LOGGER.log(Level.WARNING, msg, objs);
    }

    public static void info(String msg, Object ... objs) {
        LOGGER.log(Level.INFO, msg, objs);
    }

    public static void severe(String msg, Object ... objs) {
        LOGGER.log(Level.SEVERE, msg, objs);
    }

    public static void fine(String msg, Object ... objs) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(STRINGS.get(msg, objs));
        }
    }

    static synchronized void setConsoleLevel(Level level) {
        for (Handler h : LOGGER.getHandlers()) {
            if (!ConsoleHandler.class.isAssignableFrom(h.getClass())) continue;
            h.setLevel(level);
        }
    }

    static synchronized void addLogFileHandler(String logFile) {
        try {
            if (logFile == null || logfileHandler != null) {
                return;
            }
            logfileHandler = new FileHandler(logFile, true);
            logfileHandler.setFormatter((Formatter)new ODLLogFormatter());
            logfileHandler.setLevel(Level.INFO);
            LOGGER.addHandler(logfileHandler);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static synchronized void removeLogFileHandler() {
        if (logfileHandler != null) {
            LOGGER.removeHandler(logfileHandler);
            logfileHandler.close();
            logfileHandler = null;
        }
    }

    static {
        STRINGS = new LocalStringsImpl(GFLauncherLogger.class);
        LOGGER = Logger.getLogger(LOGGER_NAME, SHARED_LOGMESSAGE_RESOURCE);
        LOGGER.setLevel(Level.INFO);
        LOGGER.setUseParentHandlers(false);
        LOGGER.addHandler(new ConsoleHandler());
    }
}

