/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.openapi.impl.model.util;

import fish.payara.microprofile.openapi.api.visitor.ApiContext;
import fish.payara.microprofile.openapi.impl.model.OperationImpl;
import fish.payara.microprofile.openapi.impl.visitor.AnnotationInfo;
import fish.payara.microprofile.openapi.impl.visitor.OpenApiContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.ws.rs.BeanParam;
import javax.ws.rs.CookieParam;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.models.Constructible;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.Reference;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.glassfish.hk2.classmodel.reflect.AnnotatedElement;
import org.glassfish.hk2.classmodel.reflect.AnnotationModel;
import org.glassfish.hk2.classmodel.reflect.ExtensibleType;
import org.glassfish.hk2.classmodel.reflect.FieldModel;
import org.glassfish.hk2.classmodel.reflect.MethodModel;
import org.glassfish.hk2.classmodel.reflect.Parameter;
import org.glassfish.hk2.classmodel.reflect.ParameterizedType;

public final class ModelUtils {
    private static final Logger LOGGER = Logger.getLogger(ModelUtils.class.getName());
    public static final String UNKNOWN_ELEMENT_NAME = "?";

    private ModelUtils() {
    }

    public static String normaliseUrl(String path) {
        if (path == null) {
            return null;
        }
        path = "/" + path;
        if ((path = path.replaceAll("/+", "/")).endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (path.isEmpty()) {
            path = "/";
        }
        return path;
    }

    public static PathItem.HttpMethod getHttpMethod(OpenApiContext context, MethodModel method) {
        AnnotationInfo annotations = context.getAnnotationInfo((ExtensibleType<? extends ExtensibleType>)method.getDeclaringType());
        if (annotations.isAnnotationPresent(GET.class, method)) {
            return PathItem.HttpMethod.GET;
        }
        if (annotations.isAnnotationPresent(POST.class, method)) {
            return PathItem.HttpMethod.POST;
        }
        if (annotations.isAnnotationPresent(PUT.class, method)) {
            return PathItem.HttpMethod.PUT;
        }
        if (annotations.isAnnotationPresent(DELETE.class, method)) {
            return PathItem.HttpMethod.DELETE;
        }
        if (annotations.isAnnotationPresent(HEAD.class, method)) {
            return PathItem.HttpMethod.HEAD;
        }
        if (annotations.isAnnotationPresent(OPTIONS.class, method)) {
            return PathItem.HttpMethod.OPTIONS;
        }
        if (annotations.isAnnotationPresent(PATCH.class, method)) {
            return PathItem.HttpMethod.PATCH;
        }
        return null;
    }

    public static PathItem.HttpMethod getHttpMethod(String method) {
        if (method.equalsIgnoreCase("GET")) {
            return PathItem.HttpMethod.GET;
        }
        if (method.equalsIgnoreCase("POST")) {
            return PathItem.HttpMethod.POST;
        }
        if (method.equalsIgnoreCase("PUT")) {
            return PathItem.HttpMethod.PUT;
        }
        if (method.equalsIgnoreCase("DELETE")) {
            return PathItem.HttpMethod.DELETE;
        }
        if (method.equalsIgnoreCase("HEAD")) {
            return PathItem.HttpMethod.HEAD;
        }
        if (method.equalsIgnoreCase("OPTIONS")) {
            return PathItem.HttpMethod.OPTIONS;
        }
        if (method.equalsIgnoreCase("PATCH")) {
            return PathItem.HttpMethod.PATCH;
        }
        return null;
    }

    public static Operation getOrCreateOperation(PathItem pathItem, PathItem.HttpMethod httpMethod) {
        OperationImpl operation = new OperationImpl();
        if (pathItem.getOperations().get(httpMethod) != null) {
            return (Operation)pathItem.getOperations().get(httpMethod);
        }
        switch (httpMethod) {
            case GET: {
                pathItem.setGET((Operation)operation);
                break;
            }
            case POST: {
                pathItem.setPOST((Operation)operation);
                break;
            }
            case PUT: {
                pathItem.setPUT((Operation)operation);
                break;
            }
            case DELETE: {
                pathItem.setDELETE((Operation)operation);
                break;
            }
            case HEAD: {
                pathItem.setHEAD((Operation)operation);
                break;
            }
            case OPTIONS: {
                pathItem.setOPTIONS((Operation)operation);
                break;
            }
            case PATCH: {
                pathItem.setPATCH((Operation)operation);
                break;
            }
            case TRACE: {
                pathItem.setTRACE((Operation)operation);
                break;
            }
            default: {
                throw new IllegalArgumentException("HTTP method not recognised.");
            }
        }
        return operation;
    }

    public static Operation findOperation(OpenApiContext context, OpenAPI api, MethodModel method, String path) {
        Operation foundOperation = null;
        try {
            return (Operation)api.getPaths().getPathItem(path).getOperations().get(ModelUtils.getHttpMethod(context, method));
        }
        catch (NullPointerException nullPointerException) {
            return foundOperation;
        }
    }

    public static void removeOperation(PathItem pathItem, Operation operation) {
        if (operation == null) {
            return;
        }
        if (operation.equals(pathItem.getGET())) {
            pathItem.setGET(null);
        }
        if (operation.equals(pathItem.getPOST())) {
            pathItem.setPOST(null);
        }
        if (operation.equals(pathItem.getPUT())) {
            pathItem.setPUT(null);
        }
        if (operation.equals(pathItem.getDELETE())) {
            pathItem.setDELETE(null);
        }
        if (operation.equals(pathItem.getHEAD())) {
            pathItem.setHEAD(null);
        }
        if (operation.equals(pathItem.getPATCH())) {
            pathItem.setPATCH(null);
        }
        if (operation.equals(pathItem.getOPTIONS())) {
            pathItem.setOPTIONS(null);
        }
        if (operation.equals(pathItem.getTRACE())) {
            pathItem.setTRACE(null);
        }
    }

    public static String getSchemaName(ApiContext context, AnnotatedElement type) {
        Class[] ANNOTATION_TYPES;
        assert (type != null);
        for (Class annotationType : ANNOTATION_TYPES = new Class[]{Schema.class, XmlRootElement.class, XmlElement.class}) {
            String name;
            AnnotationModel annotationModel;
            if (context != null && type instanceof ExtensibleType) {
                ExtensibleType implementationType = (ExtensibleType)type;
                AnnotationInfo annotationInfo = context.getAnnotationInfo((ExtensibleType<? extends ExtensibleType>)implementationType);
                annotationModel = annotationInfo.getAnnotation(annotationType);
            } else {
                annotationModel = type.getAnnotation(annotationType.getName());
            }
            if (annotationModel == null && type instanceof FieldModel) {
                FieldModel field = (FieldModel)type;
                String accessorName = ModelUtils.getAccessorName(field.getName());
                for (MethodModel method : field.getDeclaringType().getMethods()) {
                    if (!accessorName.equals(method.getName())) continue;
                    annotationModel = type.getAnnotation(annotationType.getName());
                    break;
                }
            }
            if (annotationModel == null || (name = (String)annotationModel.getValue("name", String.class)) == null || name.isEmpty() || name.equals("##default")) continue;
            return name;
        }
        return ModelUtils.getSimpleName(type.getName());
    }

    public static String getAccessorName(String fieldName) {
        char firstCharacter = Character.toUpperCase(fieldName.charAt(0));
        return "get" + firstCharacter + fieldName.substring(1);
    }

    public static Schema.SchemaType getSchemaType(ParameterizedType type, ApiContext context) {
        if (type.isArray()) {
            return Schema.SchemaType.ARRAY;
        }
        return ModelUtils.getSchemaType(type.getTypeName(), context);
    }

    public static Schema.SchemaType getSchemaType(String typeName, ApiContext context) {
        if (String.class.getName().equals(typeName)) {
            return Schema.SchemaType.STRING;
        }
        if ("boolean".equals(typeName) || Boolean.class.getName().equals(typeName)) {
            return Schema.SchemaType.BOOLEAN;
        }
        if ("int".equals(typeName) || Integer.class.getName().equals(typeName)) {
            return Schema.SchemaType.INTEGER;
        }
        if ("short".equals(typeName) || "long".equals(typeName) || "float".equals(typeName) || "double".equals(typeName) || Short.class.getName().equals(typeName) || Long.class.getName().equals(typeName) || Float.class.getName().equals(typeName) || Double.class.getName().equals(typeName)) {
            return Schema.SchemaType.NUMBER;
        }
        if (typeName != null && typeName.endsWith("[]")) {
            return Schema.SchemaType.ARRAY;
        }
        Class<?> clazz = null;
        try {
            clazz = context.getApplicationClassLoader().loadClass(typeName);
        }
        catch (Throwable app) {
            try {
                clazz = Class.forName(typeName);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (clazz != null && (clazz.isArray() || Iterable.class.isAssignableFrom(clazz))) {
            return Schema.SchemaType.ARRAY;
        }
        return Schema.SchemaType.OBJECT;
    }

    public static boolean isMap(String typeName, ApiContext context) {
        Class<?> clazz = null;
        try {
            clazz = context.getApplicationClassLoader().loadClass(typeName);
        }
        catch (Throwable app) {
            try {
                clazz = Class.forName(typeName);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return Map.class.isAssignableFrom(clazz);
    }

    public static Schema.SchemaType getParentSchemaType(Schema.SchemaType type1, Schema.SchemaType type2) {
        if (type1 == null && type2 == null) {
            return null;
        }
        if (type1 == null) {
            return type2;
        }
        if (type2 == null) {
            return type1;
        }
        if (type1 == Schema.SchemaType.OBJECT || type2 == Schema.SchemaType.OBJECT) {
            return Schema.SchemaType.OBJECT;
        }
        if (type1 == Schema.SchemaType.STRING || type2 == Schema.SchemaType.STRING) {
            return Schema.SchemaType.STRING;
        }
        if (type1 != type2) {
            return Schema.SchemaType.STRING;
        }
        return type1;
    }

    public static boolean isRequestBody(ApiContext context, Parameter parameter) {
        AnnotationInfo annotations = context.getAnnotationInfo((ExtensibleType<? extends ExtensibleType>)parameter.getMethod().getDeclaringType());
        if (annotations.getAnnotationCount(parameter) == 0) {
            return true;
        }
        return !annotations.isAnyAnnotationPresent((AnnotatedElement)parameter, FormParam.class, QueryParam.class, MatrixParam.class, BeanParam.class, HeaderParam.class, PathParam.class, CookieParam.class, Context.class, Inject.class, Provider.class);
    }

    public static Parameter.In getParameterType(ApiContext context, Parameter parameter) {
        AnnotationInfo annotations = context.getAnnotationInfo((ExtensibleType<? extends ExtensibleType>)parameter.getMethod().getDeclaringType());
        if (annotations.isAnnotationPresent(PathParam.class, parameter)) {
            return Parameter.In.PATH;
        }
        if (annotations.isAnnotationPresent(QueryParam.class, parameter)) {
            return Parameter.In.QUERY;
        }
        if (annotations.isAnnotationPresent(HeaderParam.class, parameter)) {
            return Parameter.In.HEADER;
        }
        if (annotations.isAnnotationPresent(CookieParam.class, parameter)) {
            return Parameter.In.COOKIE;
        }
        return null;
    }

    public static String getParameterName(ApiContext context, Parameter parameter) {
        AnnotationInfo annotations = context.getAnnotationInfo((ExtensibleType<? extends ExtensibleType>)parameter.getMethod().getDeclaringType());
        if (annotations.isAnnotationPresent(PathParam.class, parameter)) {
            return annotations.getAnnotationValue(PathParam.class, (AnnotatedElement)parameter);
        }
        if (annotations.isAnnotationPresent(QueryParam.class, parameter)) {
            return annotations.getAnnotationValue(QueryParam.class, (AnnotatedElement)parameter);
        }
        if (annotations.isAnnotationPresent(HeaderParam.class, parameter)) {
            return annotations.getAnnotationValue(HeaderParam.class, (AnnotatedElement)parameter);
        }
        if (annotations.isAnnotationPresent(CookieParam.class, parameter)) {
            return annotations.getAnnotationValue(CookieParam.class, (AnnotatedElement)parameter);
        }
        return null;
    }

    public static boolean isVoid(ParameterizedType type) {
        if (type == null) {
            return true;
        }
        String typeName = type.getTypeName();
        if (typeName == null) {
            return true;
        }
        if ("void".equals(typeName)) {
            return true;
        }
        return "java.lang.Void".equals(typeName);
    }

    public static boolean isAnnotationNull(Annotation annotation) {
        if (annotation == null) {
            return true;
        }
        for (Method m : annotation.annotationType().getDeclaredMethods()) {
            if (m.getParameterCount() != 0) continue;
            try {
                Object value = m.invoke((Object)annotation, new Object[0]);
                if (value.getClass().isArray() && Array.getLength(value) > 0) {
                    return false;
                }
                if (value instanceof Boolean && ((Boolean)value).booleanValue()) {
                    return false;
                }
                if (value instanceof Class && value != Void.class) {
                    return false;
                }
                if (value instanceof Enum && !((Enum)value).name().equalsIgnoreCase("DEFAULT")) {
                    return false;
                }
                if (value instanceof String && !value.toString().isEmpty()) {
                    return false;
                }
                if (!(value instanceof Annotation) || ModelUtils.isAnnotationNull((Annotation)value)) continue;
                return false;
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                LOGGER.log(Level.WARNING, "Unable to access annotation element.", ex);
            }
        }
        return true;
    }

    public static <T> void extractAnnotations(AnnotationModel annotationModel, ApiContext context, String type, String key, BiFunction<AnnotationModel, ApiContext, T> factory, BiConsumer<String, T> wrapperAddFunction) {
        if (wrapperAddFunction == null) {
            throw new IllegalArgumentException("null wrapperAddFunction. This is required to modify OpenAPI documents");
        }
        List annotations = (List)annotationModel.getValue(type, List.class);
        if (annotations != null) {
            for (AnnotationModel annotation : annotations) {
                wrapperAddFunction.accept((String)annotation.getValue(key, String.class), (String)factory.apply(annotation, context));
            }
        }
    }

    public static <T> void extractAnnotations(AnnotationModel annotationModel, ApiContext context, String type, BiFunction<AnnotationModel, ApiContext, T> factory, Consumer<T> wrapperAddFunction) {
        if (wrapperAddFunction == null) {
            throw new IllegalArgumentException("null wrapperAddFunction. This is required to modify OpenAPI documents");
        }
        List annotations = (List)annotationModel.getValue(type, List.class);
        if (annotations != null) {
            for (AnnotationModel annotation : annotations) {
                wrapperAddFunction.accept(factory.apply(annotation, context));
            }
        }
    }

    public static <T> void mergeImmutableList(List<T> from, List<T> to, Consumer<List<T>> setFunction) {
        ArrayList<T> list = new ArrayList<T>();
        if (from != null) {
            list.addAll(from);
        }
        if (to != null) {
            list.addAll(to);
        }
        setFunction.accept(list);
    }

    public static Boolean mergeProperty(Boolean current, boolean offer, boolean override) {
        return ModelUtils.mergeProperty(current, Boolean.valueOf(offer), override);
    }

    public static Boolean mergeProperty(boolean current, Boolean offer, boolean override) {
        return ModelUtils.mergeProperty(Boolean.valueOf(current), offer, override);
    }

    public static Boolean mergeProperty(boolean current, boolean offer, boolean override) {
        return ModelUtils.mergeProperty(Boolean.valueOf(current), Boolean.valueOf(offer), override);
    }

    public static <E> E mergeProperty(E current, E offer, boolean override) {
        if (offer instanceof String && offer.toString().isEmpty()) {
            offer = null;
        }
        if (offer instanceof Integer && (offer.equals(Integer.MAX_VALUE) || offer.equals(Integer.MIN_VALUE))) {
            offer = null;
        }
        E resolve = current;
        if (offer != null) {
            if (override) {
                resolve = offer;
            } else if (current == null) {
                resolve = offer;
            }
        }
        return resolve;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void applyReference(Reference<?> referee, String reference) {
        referee.setRef(reference);
        for (Field field : referee.getClass().getDeclaredFields()) {
            boolean accessible = field.isAccessible();
            field.setAccessible(true);
            try {
                Object currentValue = field.get(referee);
                if (currentValue == null || field.getName().equals("ref")) continue;
                if (Collection.class.isAssignableFrom(field.getType())) {
                    ((Collection)field.get(referee)).clear();
                    continue;
                }
                if (field.getType().isArray()) {
                    field.set(referee, field.getType().getClass().cast(new Object[0]));
                    continue;
                }
                field.set(referee, null);
            }
            catch (Exception ex) {
            }
            finally {
                field.setAccessible(accessible);
            }
        }
    }

    public static <T> void overwrite(T from, T to) {
        if (to != null && from != null) {
            for (Field f : to.getClass().getDeclaredFields()) {
                f.setAccessible(true);
                try {
                    f.set(to, f.get(from));
                }
                catch (IllegalAccessException | IllegalArgumentException exception) {
                    // empty catch block
                }
            }
        }
    }

    public static <T> void merge(T from, T to, boolean override) {
        if (from != null && to != null) {
            for (Field f : to.getClass().getDeclaredFields()) {
                if (f.isSynthetic() || Modifier.isStatic(f.getModifiers())) continue;
                f.setAccessible(true);
                try {
                    Object fromValue = f.get(from);
                    Object toValue = f.get(to);
                    if (fromValue == null) continue;
                    if (fromValue instanceof Map && toValue != null) {
                        Map fromMap = (Map)fromValue;
                        Map toMap = (Map)toValue;
                        for (Map.Entry entry : fromMap.entrySet()) {
                            if (!toMap.containsKey(entry.getKey())) {
                                toMap.put(entry.getKey(), entry.getValue());
                                continue;
                            }
                            ModelUtils.merge(entry.getValue(), toMap.get(entry.getKey()), override);
                        }
                        continue;
                    }
                    if (fromValue instanceof Collection && toValue != null) {
                        Collection fromCollection = (Collection)fromValue;
                        Collection toCollection = (Collection)toValue;
                        for (Map.Entry o : fromCollection) {
                            if (toCollection.contains(o)) continue;
                            toCollection.add(o);
                        }
                        continue;
                    }
                    if (fromValue instanceof Constructible) {
                        if (toValue == null) {
                            f.set(to, fromValue.getClass().newInstance());
                            toValue = f.get(to);
                        }
                        ModelUtils.merge(fromValue, toValue, override);
                        continue;
                    }
                    f.set(to, ModelUtils.mergeProperty(f.get(to), f.get(from), override));
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException exception) {
                    // empty catch block
                }
            }
        }
    }

    public static String getSimpleName(String fqn) {
        String simpleName = fqn.substring(fqn.lastIndexOf(46) + 1);
        return simpleName.substring(simpleName.lastIndexOf(36) + 1);
    }

    public static <K, V> Map<K, V> readOnlyView(Map<K, V> map) {
        if (map == null) {
            return null;
        }
        return Collections.unmodifiableMap(map);
    }

    public static <T> List<T> readOnlyView(List<T> list) {
        if (list == null) {
            return null;
        }
        return Collections.unmodifiableList(list);
    }

    public static <T> List<T> createList() {
        return new ArrayList();
    }

    public static <T> List<T> createList(Collection<? extends T> items) {
        if (items == null) {
            return null;
        }
        return new ArrayList<T>(items);
    }

    public static <K, V> Map<K, V> createMap() {
        return new LinkedHashMap();
    }

    public static <K, V> Map<K, V> createMap(Map<? extends K, ? extends V> items) {
        if (items == null) {
            return null;
        }
        return new LinkedHashMap<K, V>(items);
    }

    public static <K, V> Map<K, V> createOrderedMap() {
        return new TreeMap();
    }

    public static <K, V> Map<K, V> createOrderedMap(Map<? extends K, ? extends V> items) {
        if (items == null) {
            return null;
        }
        return new TreeMap<K, V>(items);
    }
}

