/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.openapi.impl.model.media;

import fish.payara.microprofile.openapi.api.visitor.ApiContext;
import fish.payara.microprofile.openapi.impl.model.ExtensibleImpl;
import fish.payara.microprofile.openapi.impl.model.headers.HeaderImpl;
import fish.payara.microprofile.openapi.impl.model.util.ModelUtils;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.headers.Header;
import org.eclipse.microprofile.openapi.models.media.Encoding;
import org.glassfish.hk2.classmodel.reflect.AnnotationModel;

public class EncodingImpl
extends ExtensibleImpl<Encoding>
implements Encoding {
    private String contentType;
    private Map<String, Header> headers = ModelUtils.createMap();
    private Encoding.Style style;
    private Boolean explode;
    private Boolean allowReserved;

    public static Encoding createInstance(AnnotationModel annotation, ApiContext context) {
        EncodingImpl from = new EncodingImpl();
        from.setContentType((String)annotation.getValue("contentType", String.class));
        HeaderImpl.createInstances(annotation, context).forEach((arg_0, arg_1) -> ((Encoding)from).addHeader(arg_0, arg_1));
        String styleEnum = (String)annotation.getValue("style", String.class);
        if (styleEnum != null) {
            from.setStyle(Encoding.Style.valueOf((String)styleEnum.toUpperCase()));
        }
        from.setExplode((Boolean)annotation.getValue("explode", Boolean.class));
        from.setAllowReserved((Boolean)annotation.getValue("allowReserved", Boolean.class));
        return from;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public Map<String, Header> getHeaders() {
        return ModelUtils.readOnlyView(this.headers);
    }

    public void setHeaders(Map<String, Header> headers) {
        this.headers = ModelUtils.createMap(headers);
    }

    public Encoding addHeader(String key, Header header) {
        if (header != null) {
            if (this.headers == null) {
                this.headers = ModelUtils.createMap();
            }
            this.headers.put(key, header);
        }
        return this;
    }

    public void removeHeader(String key) {
        if (this.headers != null) {
            this.headers.remove(key);
        }
    }

    public Encoding.Style getStyle() {
        return this.style;
    }

    public void setStyle(Encoding.Style style) {
        this.style = style;
    }

    public Boolean getExplode() {
        return this.explode;
    }

    public void setExplode(Boolean explode) {
        this.explode = explode;
    }

    public Boolean getAllowReserved() {
        return this.allowReserved;
    }

    public void setAllowReserved(Boolean allowReserved) {
        this.allowReserved = allowReserved;
    }

    public static void merge(Encoding from, Encoding to, boolean override, ApiContext context) {
        if (from == null) {
            return;
        }
        to.setContentType(ModelUtils.mergeProperty(to.getContentType(), from.getContentType(), override));
        to.setStyle(ModelUtils.mergeProperty(to.getStyle(), from.getStyle(), override));
        to.setExplode(ModelUtils.mergeProperty(to.getExplode(), from.getExplode(), override));
        to.setAllowReserved(ModelUtils.mergeProperty(to.getAllowReserved(), from.getAllowReserved(), override));
        if (from.getHeaders() != null) {
            for (Map.Entry header : from.getHeaders().entrySet()) {
                String headerName = (String)header.getKey();
                if (headerName == null) continue;
                HeaderImpl.merge(headerName, (Header)header.getValue(), ((EncodingImpl)to).headers, override, context);
            }
        }
    }

    public static void merge(String encodingName, Encoding encoding, Map<String, Encoding> encodings, boolean override, ApiContext context) {
        if (encoding == null) {
            return;
        }
        if (encodingName != null && !encodingName.isEmpty()) {
            Encoding model = encodings.getOrDefault(encodingName, new EncodingImpl());
            encodings.put(encodingName, model);
            EncodingImpl.merge(encoding, model, override, context);
        }
    }
}

