/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.enterprise.iiop.util;

import com.sun.corba.ee.spi.threadpool.NoSuchThreadPoolException;
import com.sun.corba.ee.spi.threadpool.ThreadPoolChooser;
import com.sun.corba.ee.spi.threadpool.ThreadPoolFactory;
import com.sun.corba.ee.spi.threadpool.ThreadPoolManager;
import com.sun.logging.LogDomains;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.enterprise.iiop.util.IIOPUtils;
import org.glassfish.grizzly.config.dom.ThreadPool;
import org.glassfish.internal.api.Globals;

public class S1ASThreadPoolManager
implements ThreadPoolManager {
    private static final Logger _logger = LogDomains.getLogger(S1ASThreadPoolManager.class, (String)"javax.enterprise.system.util", (boolean)false);
    private static final int DEFAULT_NUMBER_OF_QUEUES = 0;
    private static final int DEFAULT_MIN_THREAD_COUNT = 10;
    private static final int DEFAULT_MAX_THREAD_COUNT = 200;
    private static final HashMap<String, Integer> idToIndexTable = new HashMap();
    private static final HashMap<Integer, String> indexToIdTable = new HashMap();
    private static final ArrayList<com.sun.corba.ee.spi.threadpool.ThreadPool> threadpoolList = new ArrayList();
    private static String defaultID;
    private static ThreadPoolManager s1asThreadPoolMgr;
    private static IIOPUtils _iiopUtils;

    public static ThreadPoolManager getThreadPoolManager() {
        return s1asThreadPoolMgr;
    }

    S1ASThreadPoolManager() {
    }

    private static void createThreadPools(ThreadPool threadpoolBean, int index) {
        int idleTimeoutInSeconds;
        int maxThreads;
        int minThreads;
        String threadpoolId;
        block17: {
            block16: {
                block15: {
                    block14: {
                        threadpoolId = null;
                        minThreads = 10;
                        maxThreads = 200;
                        idleTimeoutInSeconds = 120000;
                        try {
                            threadpoolId = threadpoolBean.getName();
                        }
                        catch (NullPointerException npe) {
                            if (!_logger.isLoggable(Level.WARNING)) break block14;
                            _logger.log(Level.WARNING, "ThreadPoolBean may be null ", npe);
                        }
                    }
                    try {
                        String minThreadsValue = threadpoolBean.getMinThreadPoolSize();
                        minThreads = Integer.parseInt(minThreadsValue);
                    }
                    catch (NullPointerException npe) {
                        if (_logger.isLoggable(Level.WARNING)) {
                            _logger.log(Level.WARNING, "ThreadPoolBean may be null ", npe);
                            _logger.log(Level.WARNING, "Using default value for steady-threadpool-size = " + minThreads);
                        }
                    }
                    catch (NumberFormatException nfe) {
                        if (!_logger.isLoggable(Level.WARNING)) break block15;
                        _logger.log(Level.WARNING, "enterprise_util.excep_orbmgr_numfmt", nfe);
                        _logger.log(Level.WARNING, "Using default value for min-threadpool-size = " + minThreads);
                    }
                }
                try {
                    String maxThreadsValue = threadpoolBean.getMaxThreadPoolSize();
                    maxThreads = Integer.parseInt(maxThreadsValue);
                }
                catch (NullPointerException npe) {
                    if (_logger.isLoggable(Level.WARNING)) {
                        _logger.log(Level.WARNING, "ThreadPoolBean may be null ", npe);
                        _logger.log(Level.WARNING, "Using default value for max-threadpool-size = " + maxThreads);
                    }
                }
                catch (NumberFormatException nfe) {
                    if (!_logger.isLoggable(Level.WARNING)) break block16;
                    _logger.log(Level.WARNING, "enterprise_util.excep_orbmgr_numfmt", nfe);
                    _logger.log(Level.WARNING, "Using default value for max-threadpool-size = " + maxThreads);
                }
            }
            try {
                String timeoutValue = threadpoolBean.getIdleThreadTimeoutSeconds();
                idleTimeoutInSeconds = Integer.parseInt(timeoutValue);
            }
            catch (NullPointerException npe) {
                if (_logger.isLoggable(Level.WARNING)) {
                    _logger.log(Level.WARNING, "ThreadPoolBean may be null ", npe);
                    _logger.log(Level.WARNING, "Using default value for idle-thread-timeout-in-seconds = " + idleTimeoutInSeconds);
                }
            }
            catch (NumberFormatException nfe) {
                if (!_logger.isLoggable(Level.WARNING)) break block17;
                _logger.log(Level.WARNING, "enterprise_util.excep_orbmgr_numfmt", nfe);
                _logger.log(Level.WARNING, "Using default value for idle-thread-timeout-in-seconds = " + idleTimeoutInSeconds);
            }
        }
        ThreadPoolFactory threadPoolFactory = new ThreadPoolFactory();
        com.sun.corba.ee.spi.threadpool.ThreadPool threadpool = threadPoolFactory.create(minThreads, maxThreads, (long)idleTimeoutInSeconds * 1000L, threadpoolId, _iiopUtils.getCommonClassLoader());
        threadpoolList.add(threadpool);
        idToIndexTable.put(threadpoolId, index);
        indexToIdTable.put(index, threadpoolId);
    }

    public com.sun.corba.ee.spi.threadpool.ThreadPool getThreadPool(String id) throws NoSuchThreadPoolException {
        Integer i = idToIndexTable.get(id);
        if (i == null) {
            throw new NoSuchThreadPoolException();
        }
        try {
            com.sun.corba.ee.spi.threadpool.ThreadPool threadpool = threadpoolList.get(i);
            return threadpool;
        }
        catch (IndexOutOfBoundsException iobe) {
            throw new NoSuchThreadPoolException();
        }
    }

    public com.sun.corba.ee.spi.threadpool.ThreadPool getThreadPool(int numericIdForThreadpool) throws NoSuchThreadPoolException {
        try {
            com.sun.corba.ee.spi.threadpool.ThreadPool threadpool = threadpoolList.get(numericIdForThreadpool);
            return threadpool;
        }
        catch (IndexOutOfBoundsException iobe) {
            throw new NoSuchThreadPoolException();
        }
    }

    public int getThreadPoolNumericId(String id) {
        Integer i = idToIndexTable.get(id);
        return i == null ? 0 : i;
    }

    public String getThreadPoolStringId(int numericIdForThreadpool) {
        String id = indexToIdTable.get(numericIdForThreadpool);
        return id == null ? defaultID : id;
    }

    public com.sun.corba.ee.spi.threadpool.ThreadPool getDefaultThreadPool() {
        try {
            return this.getThreadPool(0);
        }
        catch (NoSuchThreadPoolException nstpe) {
            if (_logger.isLoggable(Level.WARNING)) {
                _logger.log(Level.WARNING, "No default ThreadPool defined ", nstpe);
            }
            return null;
        }
    }

    public ThreadPoolChooser getThreadPoolChooser(String componentId) {
        return null;
    }

    public ThreadPoolChooser getThreadPoolChooser(int componentIndex) {
        return null;
    }

    public void setThreadPoolChooser(String componentId, ThreadPoolChooser aThreadPoolChooser) {
    }

    public int getThreadPoolChooserNumericId(String componentId) {
        return 0;
    }

    public void close() {
    }

    static {
        s1asThreadPoolMgr = new S1ASThreadPoolManager();
        try {
            _iiopUtils = (IIOPUtils)Globals.getDefaultHabitat().getService(IIOPUtils.class, new Annotation[0]);
            Collection<ThreadPool> tpCol = _iiopUtils.getAllThreadPools();
            ThreadPool[] allThreadPools = tpCol.toArray(new ThreadPool[tpCol.size()]);
            for (int i = 0; i < allThreadPools.length; ++i) {
                S1ASThreadPoolManager.createThreadPools(allThreadPools[i], i);
            }
            defaultID = indexToIdTable.get(0);
        }
        catch (NullPointerException npe) {
            _logger.log(Level.FINE, "Server Context is NULL. Ignoring and proceeding.");
        }
    }
}

