/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.microprofile.config.spi;

import fish.payara.nucleus.microprofile.config.spi.ConfigProviderResolverImpl;
import java.io.Serializable;
import java.util.Optional;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigValue;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.Converter;

public class InjectedPayaraConfig
implements Config,
Serializable {
    private static final long serialVersionUID = 1L;
    private transient Config delegate;
    private String appName;

    public InjectedPayaraConfig(Config delegate, String appName) {
        this.delegate = delegate;
        this.appName = appName;
    }

    public <T> T getValue(String propertyName, Class<T> propertyType) {
        this.ensureDelegate();
        return (T)this.delegate.getValue(propertyName, propertyType);
    }

    public <T> Optional<T> getOptionalValue(String propertyName, Class<T> propertyType) {
        this.ensureDelegate();
        return this.delegate.getOptionalValue(propertyName, propertyType);
    }

    public Iterable<String> getPropertyNames() {
        this.ensureDelegate();
        return this.delegate.getPropertyNames();
    }

    public Iterable<ConfigSource> getConfigSources() {
        this.ensureDelegate();
        return this.delegate.getConfigSources();
    }

    public ConfigValue getConfigValue(String propertyName) {
        this.ensureDelegate();
        return this.delegate.getConfigValue(propertyName);
    }

    public <T> Optional<Converter<T>> getConverter(Class<T> forType) {
        this.ensureDelegate();
        return this.delegate.getConverter(forType);
    }

    public <T> T unwrap(Class<T> type) {
        this.ensureDelegate();
        return (T)this.delegate.unwrap(type);
    }

    private void ensureDelegate() {
        if (this.delegate == null) {
            this.delegate = ((ConfigProviderResolverImpl)ConfigProviderResolver.instance()).getNamedConfig(this.appName);
        }
    }
}

