/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.microprofile.config.source;

import fish.payara.nucleus.microprofile.config.spi.JDBCConfigSourceConfiguration;
import java.io.Closeable;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class JDBCConfigSourceHelper
implements Closeable {
    private static final Logger LOGGER = Logger.getLogger(JDBCConfigSourceHelper.class.getName());
    private final Connection connection;
    private final PreparedStatement selectOne;
    private final PreparedStatement selectAll;

    public JDBCConfigSourceHelper(JDBCConfigSourceConfiguration configuration) {
        DataSource datasource;
        String jdbcJNDIName = configuration.getJndiName();
        Connection connection = null;
        PreparedStatement selectOne = null;
        PreparedStatement selectAll = null;
        if (jdbcJNDIName != null && !jdbcJNDIName.trim().isEmpty() && (datasource = this.getDatasource(jdbcJNDIName)) != null) {
            String table = configuration.getTableName();
            String keyColumn = configuration.getKeyColumnName();
            String valueColumn = configuration.getValueColumnName();
            String queryOne = "select " + valueColumn + " from " + table + " where " + keyColumn + " = ?";
            String queryAll = "select " + keyColumn + ", " + valueColumn + " from " + table;
            try {
                connection = datasource.getConnection();
                selectOne = connection.prepareStatement(queryOne);
                selectAll = connection.prepareStatement(queryAll);
            }
            catch (SQLException ex) {
                LOGGER.log(Level.WARNING, ex.getLocalizedMessage(), ex);
            }
        }
        this.connection = connection;
        this.selectOne = selectOne;
        this.selectAll = selectAll;
    }

    public synchronized String getConfigValue(String propertyName) {
        if (this.selectOne != null) {
            try {
                this.selectOne.setString(1, propertyName);
                ResultSet resultSet = this.selectOne.executeQuery();
                if (resultSet.next()) {
                    return resultSet.getString(1);
                }
            }
            catch (SQLException ex) {
                LOGGER.log(Level.WARNING, "Error in config source SQL execution", ex);
            }
        }
        return null;
    }

    public synchronized Map<String, String> getAllConfigValues() {
        HashMap<String, String> result = new HashMap<String, String>();
        if (this.selectAll != null) {
            try {
                ResultSet resultSet = this.selectAll.executeQuery();
                while (resultSet.next()) {
                    result.put(resultSet.getString(1), resultSet.getString(2));
                }
            }
            catch (SQLException ex) {
                LOGGER.log(Level.WARNING, "Error in config source SQL execution", ex);
            }
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                throw new IOException("Error closing JDBC connection from config source", e);
            }
        }
    }

    private DataSource getDatasource(String jndiName) {
        try {
            InitialContext ctx = new InitialContext();
            return (DataSource)ctx.lookup(jndiName);
        }
        catch (NamingException ex) {
            LOGGER.warning("Could not find the datasource:" + ex.getMessage());
            return null;
        }
    }
}

