/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.microprofile.config.converters;

import fish.payara.nucleus.microprofile.config.spi.ConfigValueResolver;
import java.lang.reflect.Array;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.microprofile.config.spi.Converter;

public final class ArrayConverter<T>
implements Converter<Object> {
    private static final Logger LOGGER = Logger.getLogger(ArrayConverter.class.getName());
    private final Class<T> elementType;
    private final Converter<T> elementConverter;
    private final ConfigValueResolver.ElementPolicy elementPolicy;

    public ArrayConverter(Class<T> elementType, Converter<T> elementConverter) {
        this(elementType, elementConverter, ConfigValueResolver.ElementPolicy.FAIL);
    }

    public ArrayConverter(Class<T> elementType, Converter<T> elementConverter, ConfigValueResolver.ElementPolicy elementPolicy) {
        this.elementType = elementType;
        this.elementConverter = elementConverter;
        this.elementPolicy = elementPolicy;
    }

    public Object convert(String value) {
        String[] sourceValues = ArrayConverter.splitValue(value);
        Object array = Array.newInstance(this.elementType, sourceValues.length);
        int j = 0;
        IllegalArgumentException lastConversionException = null;
        for (String sourceValue : sourceValues) {
            if (sourceValue == null || sourceValue.isEmpty()) continue;
            try {
                Object elementValue = this.elementConverter.convert(sourceValue);
                Array.set(array, j++, elementValue);
            }
            catch (IllegalArgumentException ex) {
                if (this.elementPolicy == ConfigValueResolver.ElementPolicy.FAIL) {
                    throw ex;
                }
                if (this.elementPolicy == ConfigValueResolver.ElementPolicy.NULL) {
                    if (this.elementType.isPrimitive()) {
                        throw ex;
                    }
                    Array.set(array, j++, null);
                    continue;
                }
                lastConversionException = ex;
            }
        }
        if (j == sourceValues.length) {
            return array;
        }
        if (lastConversionException != null) {
            if (j == 0) {
                throw lastConversionException;
            }
            LOGGER.log(Level.WARNING, "Souce value defined a list with illegal elements which are ignored: " + value, lastConversionException);
        } else {
            LOGGER.warning("Souce value defined a list with empty elements which are ignored: " + value);
        }
        Object copy = Array.newInstance(this.elementType, j);
        System.arraycopy(array, 0, copy, 0, j);
        return copy;
    }

    private static String[] splitValue(String value) {
        String[] keys = value.split("(?<!\\\\),");
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = keys[i].replaceAll("\\\\,", ",");
        }
        return keys;
    }
}

