/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.microprofile.config.admin;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.util.ColumnFormatter;
import fish.payara.nucleus.microprofile.config.spi.JDBCConfigSourceConfiguration;
import fish.payara.nucleus.microprofile.config.spi.MicroprofileConfigConfiguration;
import java.util.HashMap;
import java.util.Properties;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;

@Service(name="get-jdbc-config-source-configuration")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG, CommandTarget.DEPLOYMENT_GROUP})
@RestEndpoints(value={@RestEndpoint(configBean=MicroprofileConfigConfiguration.class, opType=RestEndpoint.OpType.GET, path="get-jdbc-config-source-configuration", description="List JDBC Config Source Configuration")})
public class GetJDBCConfigSourceConfiguration
implements AdminCommand {
    private final String[] OUTPUT_HEADERS = new String[]{"JNDI Name", "Table Name", "Key-Column Name", "Value-Column Name"};
    @Inject
    private Target targetUtil;
    @Param(name="target", optional=true, defaultValue="server")
    private String target;

    public void execute(AdminCommandContext acc) {
        ActionReport actionReport = acc.getActionReport();
        Config targetConfig = this.targetUtil.getConfig(this.target);
        if (targetConfig == null) {
            actionReport.setMessage("No such config named: " + this.target);
            actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        JDBCConfigSourceConfiguration jdbcConfigSourceConfiguration = (JDBCConfigSourceConfiguration)targetConfig.getExtensionByType(JDBCConfigSourceConfiguration.class);
        ColumnFormatter columnFormatter = new ColumnFormatter(this.OUTPUT_HEADERS);
        Object[] outputValues = new Object[]{jdbcConfigSourceConfiguration.getJndiName(), jdbcConfigSourceConfiguration.getTableName(), jdbcConfigSourceConfiguration.getKeyColumnName(), jdbcConfigSourceConfiguration.getValueColumnName()};
        columnFormatter.addRow(outputValues);
        actionReport.appendMessage(columnFormatter.toString());
        HashMap<String, String> extraPropertiesMap = new HashMap<String, String>();
        extraPropertiesMap.put("jndiName", jdbcConfigSourceConfiguration.getJndiName());
        extraPropertiesMap.put("tableName", jdbcConfigSourceConfiguration.getTableName());
        extraPropertiesMap.put("keyColumnName", jdbcConfigSourceConfiguration.getKeyColumnName());
        extraPropertiesMap.put("valueColumnName", jdbcConfigSourceConfiguration.getValueColumnName());
        Properties extraProperties = new Properties();
        extraProperties.put("jdbcConfigSourceConfiguration", extraPropertiesMap);
        actionReport.setExtraProperties(extraProperties);
    }
}

